/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight;

import com.nexmo.client.insight.BaseInsightRequest;

public class StandardInsightRequest
extends BaseInsightRequest {
    private StandardInsightRequest(Builder builder) {
        this.number = builder.number;
        this.country = builder.country;
        this.cnam = builder.cnam;
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    public Boolean getCnam() {
        return this.cnam;
    }

    public static StandardInsightRequest withNumber(String number) {
        return new Builder(number).build();
    }

    public static StandardInsightRequest withNumberAndCountry(String number, String country) {
        return new Builder(number).country(country).build();
    }

    public static class Builder {
        protected String number;
        protected String country;
        protected Boolean cnam;

        public Builder(String number) {
            this.number = number;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder cnam(Boolean cnam) {
            this.cnam = cnam;
            return this;
        }

        public StandardInsightRequest build() {
            return new StandardInsightRequest(this);
        }
    }
}

