/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.application;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.application.capabilities.Capability;
import com.nexmo.client.application.capabilities.Messages;
import com.nexmo.client.application.capabilities.Rtc;
import com.nexmo.client.application.capabilities.Vbc;
import com.nexmo.client.application.capabilities.Voice;
import java.io.IOException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Application {
    private String id;
    private String name;
    private Keys keys;
    private Capabilities capabilities;

    private Application() {
    }

    private Application(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.keys = builder.keys;
        this.capabilities = builder.capabilities;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Keys getKeys() {
        return this.keys;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public String toJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new NexmoUnexpectedException("Failed to produce json from Application object.", jpe);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static Application fromJson(String json) {
        try {
            return (Application)new ObjectMapper().readValue(json, Application.class);
        }
        catch (IOException e) {
            throw new NexmoUnexpectedException("Failed to produce Application from json.", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Capabilities {
        private Voice voice;
        private Messages messages;
        private Rtc rtc;
        private Vbc vbc;

        public Voice getVoice() {
            return this.voice;
        }

        public Messages getMessages() {
            return this.messages;
        }

        public Rtc getRtc() {
            return this.rtc;
        }

        public Vbc getVbc() {
            return this.vbc;
        }

        private void setCapability(Capability.Type type, Capability capability) {
            switch (type) {
                case VOICE: {
                    this.voice = (Voice)capability;
                    break;
                }
                case MESSAGES: {
                    this.messages = (Messages)capability;
                    break;
                }
                case RTC: {
                    this.rtc = (Rtc)capability;
                    break;
                }
                case VBC: {
                    this.vbc = (Vbc)capability;
                }
            }
        }

        private void setCapability(Capability capability) {
            this.setCapability(capability.getType(), capability);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Keys {
        @JsonProperty(value="public_key")
        private String publicKey;
        @JsonProperty(value="private_key")
        private String privateKey;

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }

    public static class Builder {
        private String id;
        private String name;
        private Keys keys;
        private Capabilities capabilities;

        public Builder() {
        }

        public Builder(Application application) {
            this.id = application.id;
            this.name = application.name;
            this.keys = application.keys;
            this.capabilities = application.capabilities;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.keys = new Keys();
            this.keys.publicKey = publicKey;
            return this;
        }

        public Builder addCapability(Capability capability) {
            if (this.capabilities == null) {
                this.capabilities = new Capabilities();
            }
            this.capabilities.setCapability(capability);
            return this;
        }

        public Builder removeCapability(Capability.Type type) {
            if (this.capabilities == null) {
                this.capabilities = new Capabilities();
            }
            this.capabilities.setCapability(type, null);
            this.capabilities = this.shouldBeDeleted(this.capabilities) ? null : this.capabilities;
            return this;
        }

        public Application build() {
            return new Application(this);
        }

        private boolean shouldBeDeleted(Capabilities capabilities) {
            return capabilities.voice == null && capabilities.rtc == null && capabilities.messages == null && capabilities.vbc == null;
        }
    }
}

