/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.account.PricingRequest;
import com.nexmo.client.account.PricingResponse;
import com.nexmo.client.auth.TokenAuthMethod;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

abstract class PricingMethod
extends AbstractMethod<PricingRequest, PricingResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};

    PricingMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(PricingRequest pricingRequest) {
        return RequestBuilder.get((String)this.getUri()).addParameter("country", pricingRequest.getCountryCode());
    }

    @Override
    public PricingResponse parseResponse(HttpResponse response) throws IOException {
        return PricingResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }

    abstract String getUri();
}

