/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.AbstractClient;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.account.BalanceEndpoint;
import com.nexmo.client.account.BalanceResponse;
import com.nexmo.client.account.CreateSecretRequest;
import com.nexmo.client.account.ListSecretsResponse;
import com.nexmo.client.account.PrefixPricingEndpoint;
import com.nexmo.client.account.PrefixPricingRequest;
import com.nexmo.client.account.PrefixPricingResponse;
import com.nexmo.client.account.PricingEndpoint;
import com.nexmo.client.account.PricingRequest;
import com.nexmo.client.account.PricingResponse;
import com.nexmo.client.account.SecretManagementEndpoint;
import com.nexmo.client.account.SecretRequest;
import com.nexmo.client.account.SecretResponse;
import com.nexmo.client.account.ServiceType;
import com.nexmo.client.account.SettingsEndpoint;
import com.nexmo.client.account.SettingsRequest;
import com.nexmo.client.account.SettingsResponse;
import com.nexmo.client.account.TopUpEndpoint;
import com.nexmo.client.account.TopUpRequest;

public class AccountClient
extends AbstractClient {
    protected BalanceEndpoint balance;
    protected PricingEndpoint pricing;
    protected PrefixPricingEndpoint prefixPricing;
    protected TopUpEndpoint topUp;
    protected SecretManagementEndpoint secret;
    protected SettingsEndpoint settings;

    public AccountClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.balance = new BalanceEndpoint(httpWrapper);
        this.pricing = new PricingEndpoint(httpWrapper);
        this.prefixPricing = new PrefixPricingEndpoint(httpWrapper);
        this.topUp = new TopUpEndpoint(httpWrapper);
        this.secret = new SecretManagementEndpoint(httpWrapper);
        this.settings = new SettingsEndpoint(httpWrapper);
    }

    public BalanceResponse getBalance() throws NexmoResponseParseException, NexmoClientException {
        return this.balance.execute();
    }

    public PricingResponse getVoicePrice(String country) throws NexmoResponseParseException, NexmoClientException {
        return this.getVoicePrice(new PricingRequest(country));
    }

    private PricingResponse getVoicePrice(PricingRequest pricingRequest) throws NexmoResponseParseException, NexmoClientException {
        return this.pricing.getPrice(ServiceType.VOICE, pricingRequest);
    }

    public PricingResponse getSmsPrice(String country) throws NexmoResponseParseException, NexmoClientException {
        return this.getSmsPrice(new PricingRequest(country));
    }

    private PricingResponse getSmsPrice(PricingRequest pricingRequest) throws NexmoResponseParseException, NexmoClientException {
        return this.pricing.getPrice(ServiceType.SMS, pricingRequest);
    }

    public PrefixPricingResponse getPrefixPrice(ServiceType type, String prefix) throws NexmoResponseParseException, NexmoClientException {
        return this.getPrefixPrice(new PrefixPricingRequest(type, prefix));
    }

    private PrefixPricingResponse getPrefixPrice(PrefixPricingRequest prefixPricingRequest) throws NexmoResponseParseException, NexmoClientException {
        return this.prefixPricing.getPrice(prefixPricingRequest);
    }

    public void topUp(String transaction) throws NexmoResponseParseException, NexmoClientException {
        this.topUp(new TopUpRequest(transaction));
    }

    private void topUp(TopUpRequest request) throws NexmoResponseParseException, NexmoClientException {
        this.topUp.topUp(request);
    }

    public ListSecretsResponse listSecrets(String apiKey) throws NexmoResponseParseException, NexmoClientException {
        return this.secret.listSecrets(apiKey);
    }

    public SecretResponse getSecret(String apiKey, String secretId) throws NexmoResponseParseException, NexmoClientException {
        return this.getSecret(new SecretRequest(apiKey, secretId));
    }

    private SecretResponse getSecret(SecretRequest secretRequest) throws NexmoResponseParseException, NexmoClientException {
        return this.secret.getSecret(secretRequest);
    }

    public SecretResponse createSecret(String apiKey, String secret) throws NexmoResponseParseException, NexmoClientException {
        return this.createSecret(new CreateSecretRequest(apiKey, secret));
    }

    private SecretResponse createSecret(CreateSecretRequest createSecretRequest) throws NexmoResponseParseException, NexmoClientException {
        return this.secret.createSecret(createSecretRequest);
    }

    public void revokeSecret(String apiKey, String secretId) throws NexmoResponseParseException, NexmoClientException {
        this.revokeSecret(new SecretRequest(apiKey, secretId));
    }

    private void revokeSecret(SecretRequest secretRequest) throws NexmoResponseParseException, NexmoClientException {
        this.secret.revokeSecret(secretRequest);
    }

    public SettingsResponse updateSmsIncomingUrl(String url) throws NexmoResponseParseException, NexmoClientException {
        return this.updateSettings(SettingsRequest.withIncomingSmsUrl(url));
    }

    public SettingsResponse updateDeliveryReceiptUrl(String url) throws NexmoResponseParseException, NexmoClientException {
        return this.updateSettings(SettingsRequest.withDeliveryReceiptUrl(url));
    }

    public SettingsResponse updateSettings(SettingsRequest request) throws NexmoResponseParseException, NexmoClientException {
        return this.settings.updateSettings(request);
    }
}

