/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.voice.StreamResponse;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class StopStreamMethod
extends AbstractMethod<String, StreamResponse> {
    private static final Log LOG = LogFactory.getLog(StopStreamMethod.class);
    private static final String DEFAULT_URI = "https://api.nexmo.com/v1/calls/";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String uri = "https://api.nexmo.com/v1/calls/";

    public StopStreamMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(String uuid) throws NexmoClientException, UnsupportedEncodingException {
        String uri = this.uri + uuid + "/stream";
        return RequestBuilder.delete((String)uri).setHeader("Content-Type", "application/json");
    }

    @Override
    public StreamResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return StreamResponse.fromJson(json);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

