/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.legacyutils.XmlParser;
import com.nexmo.client.legacyutils.XmlUtil;
import com.nexmo.client.verify.SearchRequest;
import com.nexmo.client.verify.SearchResult;
import com.nexmo.client.verify.VerifyResult;
import com.nexmo.client.verify.endpoints.SharedParsers;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class SearchEndpoint
extends AbstractMethod<SearchRequest, SearchResult[]> {
    private static final Log log = LogFactory.getLog(SearchEndpoint.class);
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String DEFAULT_URI = "https://api.nexmo.com/verify/search/xml";
    private XmlParser xmlParser = new XmlParser();
    private String uri = "https://api.nexmo.com/verify/search/xml";
    private static final ThreadLocal<SimpleDateFormat> sDateTimePattern = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setLenient(false);
            return sdf;
        }
    };

    public SearchEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SearchRequest request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder result = RequestBuilder.post((String)this.uri);
        if (request.getRequestIds().length == 1) {
            result.addParameter("request_id", request.getRequestIds()[0]);
        } else {
            for (String requestId : request.getRequestIds()) {
                result.addParameter("request_ids", requestId);
            }
        }
        return result;
    }

    @Override
    public SearchResult[] parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return this.parseSearchResponse(json);
    }

    public SearchResult search(String requestId) throws IOException, NexmoClientException {
        SearchResult[] result = this.search(new String[]{requestId});
        return result != null && result.length > 0 ? result[0] : null;
    }

    public SearchResult[] search(String ... requestIds) throws IOException, NexmoClientException {
        return (SearchResult[])this.execute(new SearchRequest(requestIds));
    }

    protected SearchResult[] parseSearchResponse(String response) throws NexmoResponseParseException {
        Document doc = this.xmlParser.parseXml(response);
        Element root = doc.getDocumentElement();
        if ("verify_response".equals(root.getNodeName())) {
            VerifyResult result = SharedParsers.parseVerifyResponseXmlNode(root);
            return new SearchResult[]{new SearchResult(result.getStatus(), result.getRequestId(), null, null, null, 0.0f, null, null, null, null, null, null, null, result.getErrorText(), result.isTemporaryError())};
        }
        if ("verify_request".equals(root.getNodeName())) {
            return new SearchResult[]{SearchEndpoint.parseVerifyRequestXmlNode(root)};
        }
        if ("verification_requests".equals(root.getNodeName())) {
            ArrayList<SearchResult> results = new ArrayList<SearchResult>();
            NodeList fields = root.getChildNodes();
            for (int i = 0; i < fields.getLength(); ++i) {
                Node node = fields.item(i);
                if (node.getNodeType() != 1 || !"verify_request".equals(node.getNodeName())) continue;
                results.add(SearchEndpoint.parseVerifyRequestXmlNode((Element)node));
            }
            return results.toArray(new SearchResult[results.size()]);
        }
        throw new NexmoResponseParseException("No valid response found [ " + response + "] ");
    }

    protected static SearchResult parseVerifyRequestXmlNode(Element root) throws NexmoResponseParseException {
        String requestId = null;
        String accountId = null;
        String number = null;
        String senderId = null;
        Date dateSubmitted = null;
        Date dateFinalized = null;
        Date firstEventDate = null;
        Date lastEventDate = null;
        float price = -1.0f;
        String currency = null;
        SearchResult.VerificationStatus status = null;
        ArrayList<SearchResult.VerifyCheck> checks = new ArrayList<SearchResult.VerifyCheck>();
        String errorText = null;
        NodeList fields = root.getChildNodes();
        for (int i = 0; i < fields.getLength(); ++i) {
            String str;
            Node node = fields.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if ("request_id".equals(name)) {
                requestId = XmlUtil.stringValue(node);
                continue;
            }
            if ("account_id".equals(name)) {
                accountId = XmlUtil.stringValue(node);
                continue;
            }
            if ("status".equals(name)) {
                str = XmlUtil.stringValue(node);
                if (str == null) continue;
                try {
                    status = SearchResult.VerificationStatus.valueOf(str.replace(' ', '_'));
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("xml parser .. invalid value in <status> node [ " + str + " ] "));
                }
                continue;
            }
            if ("number".equals(name)) {
                number = XmlUtil.stringValue(node);
                continue;
            }
            if ("price".equals(name)) {
                str = XmlUtil.stringValue(node);
                try {
                    if (str == null) continue;
                    price = Float.parseFloat(str);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("xml parser .. invalid value in <price> node [ " + str + " ] "));
                }
                continue;
            }
            if ("currency".equals(name)) {
                currency = XmlUtil.stringValue(node);
                continue;
            }
            if ("sender_id".equals(name)) {
                senderId = XmlUtil.stringValue(node);
                continue;
            }
            if ("date_submitted".equals(name)) {
                str = XmlUtil.stringValue(node);
                if (str == null) continue;
                try {
                    dateSubmitted = SearchEndpoint.parseDateTime(str);
                }
                catch (ParseException e) {
                    log.error((Object)("xml parser .. invalid value in <date_submitted> node [ " + str + " ] "));
                }
                continue;
            }
            if ("date_finalized".equals(name)) {
                str = XmlUtil.stringValue(node);
                if (str == null) continue;
                try {
                    dateFinalized = SearchEndpoint.parseDateTime(str);
                }
                catch (ParseException e) {
                    log.error((Object)("xml parser .. invalid value in <date_finalized> node [ " + str + " ] "));
                }
                continue;
            }
            if ("first_event_date".equals(name)) {
                str = XmlUtil.stringValue(node);
                if (str == null) continue;
                try {
                    firstEventDate = SearchEndpoint.parseDateTime(str);
                }
                catch (ParseException e) {
                    log.error((Object)("xml parser .. invalid value in <first_event_date> node [ " + str + " ] "));
                }
                continue;
            }
            if ("last_event_date".equals(name)) {
                str = XmlUtil.stringValue(node);
                if (str == null) continue;
                try {
                    lastEventDate = SearchEndpoint.parseDateTime(str);
                }
                catch (ParseException e) {
                    log.error((Object)("xml parser .. invalid value in <last_event_date> node [ " + str + " ] "));
                }
                continue;
            }
            if ("checks".equals(name)) {
                NodeList checkNodes = node.getChildNodes();
                for (int j = 0; j < checkNodes.getLength(); ++j) {
                    Node checkNode = checkNodes.item(j);
                    if (checkNode.getNodeType() != 1 || !"check".equals(checkNode.getNodeName())) continue;
                    checks.add(SearchEndpoint.parseCheckXmlNode((Element)checkNode));
                }
                continue;
            }
            if (!"error_text".equals(name)) continue;
            errorText = XmlUtil.stringValue(node);
        }
        if (status == null) {
            throw new NexmoResponseParseException("Xml Parser - did not find a <status> node");
        }
        return new SearchResult(0, requestId, accountId, status, number, price, currency, senderId, dateSubmitted, dateFinalized, firstEventDate, lastEventDate, checks, errorText, false);
    }

    protected static SearchResult.VerifyCheck parseCheckXmlNode(Element root) throws NexmoResponseParseException {
        String code = null;
        SearchResult.VerifyCheck.Status status = null;
        Date dateReceived = null;
        String ipAddress = null;
        NodeList fields = root.getChildNodes();
        for (int i = 0; i < fields.getLength(); ++i) {
            String str;
            Node node = fields.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if ("code".equals(name)) {
                code = XmlUtil.stringValue(node);
                continue;
            }
            if ("status".equals(name)) {
                str = XmlUtil.stringValue(node);
                if (str == null) continue;
                try {
                    status = SearchResult.VerifyCheck.Status.valueOf(str);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("xml parser .. invalid value in <status> node [ " + str + " ] "));
                }
                continue;
            }
            if ("ip_address".equals(name)) {
                ipAddress = XmlUtil.stringValue(node);
                continue;
            }
            if (!"date_received".equals(name) || (str = XmlUtil.stringValue(node)) == null) continue;
            try {
                dateReceived = SearchEndpoint.parseDateTime(str);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)("xml parser .. invalid value in <date_received> node [ " + str + " ] "));
            }
        }
        if (status == null) {
            throw new NexmoResponseParseException("Xml Parser - did not find a <status> node");
        }
        return new SearchResult.VerifyCheck(dateReceived, code, status, ipAddress);
    }

    private static Date parseDateTime(String str) throws ParseException {
        return sDateTimePattern.get().parse(str);
    }
}

