/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.AbstractClient;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.verify.CheckEndpoint;
import com.nexmo.client.verify.CheckResult;
import com.nexmo.client.verify.ControlRequest;
import com.nexmo.client.verify.ControlResponse;
import com.nexmo.client.verify.SearchEndpoint;
import com.nexmo.client.verify.SearchResult;
import com.nexmo.client.verify.VerifyControlCommand;
import com.nexmo.client.verify.VerifyEndpoint;
import com.nexmo.client.verify.VerifyRequest;
import com.nexmo.client.verify.VerifyResult;
import com.nexmo.client.verify.endpoints.ControlEndpoint;
import java.io.IOException;
import java.util.Locale;

public class VerifyClient
extends AbstractClient {
    private CheckEndpoint check;
    private VerifyEndpoint verify;
    private SearchEndpoint search;
    private ControlEndpoint control;

    public VerifyClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.check = new CheckEndpoint(httpWrapper);
        this.search = new SearchEndpoint(httpWrapper);
        this.verify = new VerifyEndpoint(httpWrapper);
        this.control = new ControlEndpoint(httpWrapper);
    }

    public VerifyResult verify(String number, String brand) throws IOException, NexmoClientException {
        return this.verify.verify(number, brand);
    }

    public VerifyResult verify(String number, String brand, String from) throws IOException, NexmoClientException {
        return this.verify.verify(number, brand, from);
    }

    public VerifyResult verify(String number, String brand, String from, int length, Locale locale) throws IOException, NexmoClientException {
        return this.verify.verify(number, brand, from, length, locale);
    }

    public VerifyResult verify(String number, String brand, String from, int length, Locale locale, VerifyRequest.LineType type) throws IOException, NexmoClientException {
        return this.verify.verify(number, brand, from, length, locale, type);
    }

    public VerifyResult verify(VerifyRequest request) throws IOException, NexmoClientException {
        return this.verify.verify(request);
    }

    public CheckResult check(String requestId, String code) throws IOException, NexmoClientException {
        return this.check.check(requestId, code);
    }

    public CheckResult check(String requestId, String code, String ipAddress) throws IOException, NexmoClientException {
        return this.check.check(requestId, code, ipAddress);
    }

    public SearchResult search(String requestId) throws IOException, NexmoClientException {
        return this.search.search(requestId)[0];
    }

    public SearchResult[] search(String ... requestIds) throws IOException, NexmoClientException {
        return this.search.search(requestIds);
    }

    public ControlResponse advanceVerification(String requestId) throws IOException, NexmoClientException {
        return (ControlResponse)this.control.execute(new ControlRequest(requestId, VerifyControlCommand.TRIGGER_NEXT_EVENT));
    }

    public ControlResponse cancelVerification(String requestId) throws IOException, NexmoClientException {
        return (ControlResponse)this.control.execute(new ControlRequest(requestId, VerifyControlCommand.CANCEL));
    }
}

