/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.verify.SearchMethod;
import com.nexmo.client.verify.SearchRequest;
import com.nexmo.client.verify.SearchResult;
import com.nexmo.client.verify.SearchVerifyResponse;
import com.nexmo.client.verify.VerifyCheck;
import com.nexmo.client.verify.VerifyDetails;
import com.nexmo.client.verify.VerifyStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchEndpoint {
    private SearchMethod searchMethod;

    SearchEndpoint(HttpWrapper httpWrapper) {
        this.searchMethod = new SearchMethod(httpWrapper);
    }

    SearchResult[] search(String ... requestIds) throws IOException, NexmoClientException {
        return this.translateFromSearchVerifyResponse((SearchVerifyResponse)this.searchMethod.execute(new SearchRequest(requestIds)));
    }

    private SearchResult[] translateFromSearchVerifyResponse(SearchVerifyResponse response) {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        if (response.getStatus() != VerifyStatus.OK) {
            resultList.add(new SearchResult(response.getStatus().getVerifyStatus(), response.getErrorText(), response.getStatus().isTemporaryError()));
        } else {
            for (VerifyDetails details : response.getVerificationRequests()) {
                resultList.add(new SearchResult(response.getStatus().getVerifyStatus(), details.getRequestId(), details.getAccountId(), this.translateFromVerifyDetailsStatus(details.getStatus()), details.getNumber(), details.getPrice() != null ? details.getPrice().floatValue() : 0.0f, details.getCurrency(), details.getSenderId(), details.getDateSubmitted(), details.getDateFinalized(), details.getFirstEventDate(), details.getLastEventDate(), this.translateFromVerifyCheck(details.getChecks()), response.getErrorText(), false));
            }
        }
        return resultList.toArray(new SearchResult[0]);
    }

    private SearchResult.VerificationStatus translateFromVerifyDetailsStatus(VerifyDetails.Status status) {
        try {
            return status != null ? SearchResult.VerificationStatus.valueOf(status.name()) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private List<SearchResult.VerifyCheck> translateFromVerifyCheck(List<VerifyCheck> checks) {
        ArrayList<SearchResult.VerifyCheck> resultChecks = new ArrayList<SearchResult.VerifyCheck>();
        for (VerifyCheck check : checks) {
            resultChecks.add(new SearchResult.VerifyCheck(check.getDate(), check.getCode(), SearchResult.VerifyCheck.Status.valueOf(check.getStatus().name()), check.getIpAddress()));
        }
        return resultChecks;
    }
}

