/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.legacyutils;

import com.nexmo.client.NexmoResponseParseException;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static String stringValue(Node node) {
        return node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
    }

    public static int intValue(Node node) throws NexmoResponseParseException {
        String str = XmlUtil.stringValue(node);
        if (str != null) {
            return Integer.parseInt(str, 10);
        }
        throw new NexmoResponseParseException("Null or empty value provided for numeric value: " + node.getNodeName());
    }

    public static Document parseXmlString(DocumentBuilder documentBuilder, String response) throws NexmoResponseParseException {
        try {
            return documentBuilder.parse(new InputSource(new StringReader(response)));
        }
        catch (SAXException se) {
            throw new NexmoResponseParseException("XML parse failure", se);
        }
        catch (IOException ioe) {
            throw new NexmoResponseParseException("IOException while parsing response XML!", ioe);
        }
    }
}

