/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.applications.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.applications.ApplicationDetails;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class GetApplicationEndpoint
extends AbstractMethod<String, ApplicationDetails> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String DEFAULT_URI = "https://api.nexmo.com/v1/applications";
    private String uri = "https://api.nexmo.com/v1/applications";

    public GetApplicationEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(String applicationId) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.get((String)(this.uri + "/" + applicationId));
        return requestBuilder;
    }

    @Override
    public ApplicationDetails parseResponse(HttpResponse response) throws IOException {
        return ApplicationDetails.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

