/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.applications.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.applications.ApplicationDetails;
import com.nexmo.client.applications.CreateApplicationRequest;
import com.nexmo.client.applications.ListApplicationsRequest;
import com.nexmo.client.applications.ListApplicationsResponse;
import com.nexmo.client.applications.UpdateApplicationRequest;
import com.nexmo.client.applications.endpoints.CreateApplicationMethod;
import com.nexmo.client.applications.endpoints.DeleteApplicationMethod;
import com.nexmo.client.applications.endpoints.GetApplicationEndpoint;
import com.nexmo.client.applications.endpoints.ListApplicationsEndpoint;
import com.nexmo.client.applications.endpoints.UpdateApplicationMethod;
import java.io.IOException;

public class ApplicationsEndpoint {
    private CreateApplicationMethod create;
    private UpdateApplicationMethod update;
    private GetApplicationEndpoint get;
    private ListApplicationsEndpoint list;
    private DeleteApplicationMethod delete;

    public ApplicationsEndpoint(HttpWrapper httpWrapper) {
        this.create = new CreateApplicationMethod(httpWrapper);
        this.update = new UpdateApplicationMethod(httpWrapper);
        this.get = new GetApplicationEndpoint(httpWrapper);
        this.list = new ListApplicationsEndpoint(httpWrapper);
        this.delete = new DeleteApplicationMethod(httpWrapper);
    }

    public ApplicationDetails post(CreateApplicationRequest request) throws IOException, NexmoClientException {
        return (ApplicationDetails)this.create.execute(request);
    }

    public ApplicationDetails put(UpdateApplicationRequest request) throws IOException, NexmoClientException {
        return (ApplicationDetails)this.update.execute(request);
    }

    public ApplicationDetails get(String applicationId) throws IOException, NexmoClientException {
        return (ApplicationDetails)this.get.execute(applicationId);
    }

    public ListApplicationsResponse get(ListApplicationsRequest request) throws IOException, NexmoClientException {
        return (ListApplicationsResponse)this.list.execute(request);
    }

    public void delete(String applicationId) throws IOException, NexmoClientException {
        this.delete.execute(applicationId);
    }
}

