/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoBadRequestException;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.account.TopUpRequest;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;

public class TopUpMethod
extends AbstractMethod<TopUpRequest, Void> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String DEFAULT_URI = "https://rest.nexmo.com/account/top-up";
    private String uri = "https://rest.nexmo.com/account/top-up";

    public TopUpMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(TopUpRequest request) throws NexmoClientException, UnsupportedEncodingException {
        return RequestBuilder.get((String)this.uri).addParameter("trx", request.getTrx());
    }

    @Override
    public Void parseResponse(HttpResponse response) throws IOException, NexmoClientException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NexmoBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return null;
    }
}

