/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Network {
    private Type type;
    private BigDecimal price;
    private String currency;
    private String mcc;
    private String mnc;
    private String code;
    private String name;

    public Type getType() {
        return this.type;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getMcc() {
        return this.mcc;
    }

    public String getMnc() {
        return this.mnc;
    }

    @JsonProperty(value="networkCode")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="networkName")
    public String getName() {
        return this.name;
    }

    static enum Type {
        MOBILE,
        LANDLINE,
        PAGER,
        LANDLINE_TOLLFREE,
        UNKNOWN;

        private static final Map<String, Type> typesIndex;

        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static Type fromString(String type) {
            Type foundType = typesIndex.get(type);
            return foundType != null ? foundType : UNKNOWN;
        }

        static {
            typesIndex = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                typesIndex.put(type.toString(), type);
            }
        }
    }
}

