/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.voice.CallInfo;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class ReadCallMethod
extends AbstractMethod<String, CallInfo> {
    private static final Log LOG = LogFactory.getLog(ReadCallMethod.class);
    private static final String DEFAULT_BASE_URI = "https://api.nexmo.com/v1/calls/";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String baseUri = "https://api.nexmo.com/v1/calls/";

    public ReadCallMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(String callId) {
        String uri = this.baseUri + callId;
        return RequestBuilder.get((String)uri);
    }

    @Override
    public CallInfo parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return CallInfo.fromJson(json);
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }
}

