/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.legacyutils.XmlParser;
import com.nexmo.client.legacyutils.XmlUtil;
import com.nexmo.client.verify.CheckRequest;
import com.nexmo.client.verify.CheckResult;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyCheckMethod
extends AbstractMethod<CheckRequest, CheckResult> {
    private static final Log log = LogFactory.getLog(VerifyCheckMethod.class);
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String DEFAULT_URI = "https://api.nexmo.com/verify/check/xml";
    private XmlParser xmlParser = new XmlParser();
    private String uri = "https://api.nexmo.com/verify/check/xml";

    public VerifyCheckMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(CheckRequest request) throws NexmoClientException, UnsupportedEncodingException {
        if (request.getRequestId() == null || request.getCode() == null) {
            throw new IllegalArgumentException("request ID and code parameters are mandatory.");
        }
        RequestBuilder result = RequestBuilder.post((String)this.uri).addParameter("request_id", request.getRequestId()).addParameter("code", request.getCode());
        if (request.getIpAddress() != null) {
            result.addParameter("ip_address", request.getIpAddress());
        }
        return result;
    }

    @Override
    public CheckResult parseResponse(HttpResponse response) throws IOException {
        String body = new BasicResponseHandler().handleResponse(response);
        return this.parseCheckResponse(body);
    }

    private CheckResult parseCheckResponse(String response) throws NexmoResponseParseException {
        Document doc = this.xmlParser.parseXml(response);
        Element root = doc.getDocumentElement();
        if (!"verify_response".equals(root.getNodeName())) {
            throw new NexmoResponseParseException("No valid response found [ " + response + "] ");
        }
        String eventId = null;
        int status = -1;
        float price = -1.0f;
        String currency = null;
        String errorText = null;
        NodeList fields = root.getChildNodes();
        for (int i = 0; i < fields.getLength(); ++i) {
            String str;
            Node node = fields.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if ("event_id".equals(name)) {
                eventId = XmlUtil.stringValue(node);
                continue;
            }
            if ("status".equals(name)) {
                str = XmlUtil.stringValue(node);
                try {
                    if (str == null) continue;
                    status = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("xml parser .. invalid value in <status> node [ " + str + " ] "));
                    status = 5;
                }
                continue;
            }
            if ("price".equals(name)) {
                str = XmlUtil.stringValue(node);
                try {
                    if (str == null) continue;
                    price = Float.parseFloat(str);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("xml parser .. invalid value in <price> node [ " + str + " ] "));
                }
                continue;
            }
            if ("currency".equals(name)) {
                currency = XmlUtil.stringValue(node);
                continue;
            }
            if (!"error_text".equals(name)) continue;
            errorText = XmlUtil.stringValue(node);
        }
        if (status == -1) {
            throw new NexmoResponseParseException("Xml Parser - did not find a <status> node");
        }
        boolean temporaryError = status == 1 || status == 5;
        return new CheckResult(status, eventId, price, currency, errorText, temporaryError);
    }
}

