/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify.endpoints;

import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.legacyutils.XmlUtil;
import com.nexmo.client.verify.VerifyResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharedParsers {
    private static final Log log = LogFactory.getLog(SharedParsers.class);

    protected static VerifyResult parseVerifyResponseXmlNode(Element root) throws NexmoResponseParseException {
        String requestId = null;
        int status = -1;
        String errorText = null;
        NodeList fields = root.getChildNodes();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node node = fields.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if ("request_id".equals(name)) {
                requestId = XmlUtil.stringValue(node);
                continue;
            }
            if ("status".equals(name)) {
                String str = XmlUtil.stringValue(node);
                try {
                    if (str == null) continue;
                    status = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("xml parser .. invalid value in <status> node [ " + str + " ] "));
                    status = 5;
                }
                continue;
            }
            if (!"error_text".equals(name)) continue;
            errorText = XmlUtil.stringValue(node);
        }
        if (status == -1) {
            throw new NexmoResponseParseException("Xml Parser - did not find a <status> node");
        }
        boolean temporaryError = status == 1 || status == 5;
        return new VerifyResult(status, requestId, errorText, temporaryError);
    }
}

