/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.sms;

import com.nexmo.client.sms.SmsSubmissionReachabilityStatus;
import java.io.Serializable;
import java.math.BigDecimal;

public class SmsSubmissionResult
implements Serializable {
    private static final long serialVersionUID = 2580996244288340269L;
    public static final int STATUS_OK = 0;
    public static final int STATUS_THROTTLED = 1;
    public static final int STATUS_MISSING_PARAMS = 2;
    public static final int STATUS_INVALID_PARAMS = 3;
    public static final int STATUS_INVALID_CREDENTIALS = 4;
    public static final int STATUS_INTERNAL_ERROR = 5;
    public static final int STATUS_INVALID_MESSAGE = 6;
    public static final int STATUS_NUMBER_BARRED = 7;
    public static final int STATUS_PARTNER_ACCOUNT_BARRED = 8;
    public static final int STATUS_PARTNER_QUOTA_EXCEEDED = 9;
    public static final int STATUS_TOO_MANY_BINDS = 10;
    public static final int STATUS_ACCOUNT_NOT_HTTP = 11;
    public static final int STATUS_MESSAGE_TOO_LONG = 12;
    public static final int STATUS_COMMS_FAILURE = 13;
    public static final int STATUS_INVALID_SIGNATURE = 14;
    public static final int STATUS_INVALID_FROM_ADDRESS = 15;
    public static final int STATUS_INVALID_TTL = 16;
    public static final int STATUS_NUMBER_UNREACHABKE = 17;
    public static final int STATUS_TOO_MANY_DESTINATIONS = 18;
    public static final int STATUS_FACILITY_NOT_ALLOWED = 19;
    public static final int STATUS_INVALID_MESSAFE_CLASS = 20;
    private final int status;
    private final String destination;
    private final String messageId;
    private final String errorText;
    private final String clientReference;
    private final BigDecimal remainingBalance;
    private final BigDecimal messagePrice;
    private final boolean temporaryError;
    private final SmsSubmissionReachabilityStatus smsSubmissionReachabilityStatus;
    private final String network;

    protected SmsSubmissionResult(int status, String destination, String messageId, String errorText, String clientReference, BigDecimal remainingBalance, BigDecimal messagePrice, boolean temporaryError, SmsSubmissionReachabilityStatus smsSubmissionReachabilityStatus, String network) {
        this.status = status;
        this.destination = destination;
        this.messageId = messageId;
        this.errorText = errorText;
        this.clientReference = clientReference;
        this.remainingBalance = remainingBalance;
        this.messagePrice = messagePrice;
        this.temporaryError = temporaryError;
        this.smsSubmissionReachabilityStatus = smsSubmissionReachabilityStatus;
        this.network = network;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String getClientReference() {
        return this.clientReference;
    }

    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    public BigDecimal getMessagePrice() {
        return this.messagePrice;
    }

    public boolean getTemporaryError() {
        return this.temporaryError;
    }

    public SmsSubmissionReachabilityStatus getSmsSubmissionReachabilityStatus() {
        return this.smsSubmissionReachabilityStatus;
    }

    public String getNetwork() {
        return this.network;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SMS-SUBMIT-RESULT -- STATUS:").append(this.status);
        sb.append(" ERR:").append(this.errorText);
        sb.append(" DEST:").append(this.destination);
        sb.append(" MSG-ID:").append(this.messageId);
        sb.append(" CLIENT-REF:").append(this.clientReference);
        sb.append(" PRICE:").append(this.messagePrice == null ? "-" : this.messagePrice.toPlainString());
        sb.append(" BALANCE:").append(this.remainingBalance == null ? "-" : this.remainingBalance.toPlainString());
        sb.append(" TEMP-ERR?:").append(this.temporaryError);
        if (this.smsSubmissionReachabilityStatus != null) {
            sb.append(" REACHABLE?:").append(this.smsSubmissionReachabilityStatus);
        }
        if (this.network != null) {
            sb.append("NETWORK:").append(this.network);
        }
        return sb.toString();
    }
}

