/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.sms;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.legacyutils.XmlParser;
import com.nexmo.client.sms.SmsClient;
import com.nexmo.client.sms.SmsSubmissionReachabilityStatus;
import com.nexmo.client.sms.SmsSubmissionResult;
import com.nexmo.client.sms.messages.Message;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SendMessageEndpoint
extends AbstractMethod<Message, SmsSubmissionResult[]> {
    private static final Log log = LogFactory.getLog(SmsClient.class);
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String DEFAULT_URI = "https://rest.nexmo.com/sms/xml";
    private XmlParser xmlParser = new XmlParser();
    private String uri = "https://rest.nexmo.com/sms/xml";

    public SendMessageEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(Message message) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder request = RequestBuilder.post((String)this.uri);
        message.addParams(request);
        return request;
    }

    @Override
    public SmsSubmissionResult[] parseResponse(HttpResponse response) throws IOException {
        return this.parseResponse(new BasicResponseHandler().handleResponse(response));
    }

    protected SmsSubmissionResult[] parseResponse(String response) throws NexmoResponseParseException {
        ArrayList<SmsSubmissionResult> results = new ArrayList<SmsSubmissionResult>();
        Document doc = this.xmlParser.parseXml(response);
        NodeList replies = doc.getElementsByTagName("mt-submission-response");
        for (int i = 0; i < replies.getLength(); ++i) {
            Node reply = replies.item(i);
            NodeList messageLists = reply.getChildNodes();
            for (int i2 = 0; i2 < messageLists.getLength(); ++i2) {
                Node messagesNode = messageLists.item(i2);
                if (messagesNode.getNodeType() != 1 || !messagesNode.getNodeName().equals("messages")) continue;
                NodeList messages = messagesNode.getChildNodes();
                for (int i3 = 0; i3 < messages.getLength(); ++i3) {
                    SmsSubmissionResult message = this.parseMessageXmlNode(messages.item(i3));
                    if (message == null) continue;
                    results.add(message);
                }
            }
        }
        return results.toArray(new SmsSubmissionResult[results.size()]);
    }

    private SmsSubmissionResult parseMessageXmlNode(Node messageNode) throws NexmoResponseParseException {
        if (messageNode.getNodeType() != 1) {
            return null;
        }
        int status = -1;
        String messageId = null;
        String destination = null;
        String errorText = null;
        String clientReference = null;
        BigDecimal remainingBalance = null;
        BigDecimal messagePrice = null;
        SmsSubmissionReachabilityStatus smsSubmissionReachabilityStatus = null;
        String network = null;
        NodeList nodes = messageNode.getChildNodes();
        for (int i4 = 0; i4 < nodes.getLength(); ++i4) {
            String str;
            Node node = nodes.item(i4);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("messageId")) {
                messageId = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                continue;
            }
            if (node.getNodeName().equals("to")) {
                destination = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                continue;
            }
            if (node.getNodeName().equals("status")) {
                str = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                try {
                    status = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("xml parser .. invalid value in <status> node [ " + str + " ] "));
                    status = 5;
                }
                continue;
            }
            if (node.getNodeName().equals("errorText")) {
                errorText = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                continue;
            }
            if (node.getNodeName().equals("clientRef")) {
                clientReference = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                continue;
            }
            if (node.getNodeName().equals("remainingBalance")) {
                str = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                try {
                    if (str == null) continue;
                    remainingBalance = new BigDecimal(str);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("xml parser .. invalid value in <remainingBalance> node [ " + str + " ] "));
                }
                continue;
            }
            if (node.getNodeName().equals("messagePrice")) {
                str = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                try {
                    if (str == null) continue;
                    messagePrice = new BigDecimal(str);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("xml parser .. invalid value in <messagePrice> node [ " + str + " ] "));
                }
                continue;
            }
            if (node.getNodeName().equals("network")) {
                network = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                continue;
            }
            log.error((Object)("xml parser .. unknown node found in status-return, expected [ messageId, to, status, errorText, clientRef, messagePrice, remainingBalance, reachability, network ] -- found [ " + node.getNodeName() + " ] "));
        }
        if (status == -1) {
            throw new NexmoResponseParseException("Xml Parser - did not find a <status> node");
        }
        boolean temporaryError = status == 1 || status == 5 || status == 10;
        return new SmsSubmissionResult(status, destination, messageId, errorText, clientReference, remainingBalance, messagePrice, temporaryError, smsSubmissionReachabilityStatus, network);
    }
}

