/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.auth;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTSigner;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.auth.AbstractAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.client.methods.RequestBuilder;

public class JWTAuthMethod
extends AbstractAuthMethod {
    private static final Pattern pemPattern = Pattern.compile("-----BEGIN PRIVATE KEY-----(.*\\n)-----END PRIVATE KEY-----\\n?", 40);
    public final int SORT_KEY = 10;
    private String applicationId;
    private JWTSigner signer;

    public JWTAuthMethod(String applicationId, byte[] privateKey) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        this.applicationId = applicationId;
        byte[] decodedPrivateKey = privateKey;
        if (privateKey[0] == 45) {
            decodedPrivateKey = this.decodePrivateKey(privateKey);
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decodedPrivateKey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey key = kf.generatePrivate(spec);
        this.signer = new JWTSigner(key);
    }

    public JWTAuthMethod(String applicationId, Path path) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException, IOException {
        this(applicationId, Files.readAllBytes(path));
    }

    public static String constructJTI() {
        return UUID.randomUUID().toString();
    }

    protected byte[] decodePrivateKey(byte[] data) throws InvalidKeyException {
        try {
            String s = new String(data, "UTF-8");
            Matcher extracter = pemPattern.matcher(s);
            if (extracter.matches()) {
                String pemBody = extracter.group(1);
                return DatatypeConverter.parseBase64Binary((String)pemBody);
            }
            throw new InvalidKeyException("Private key should be provided in PEM format!");
        }
        catch (UnsupportedEncodingException exc) {
            throw new NexmoUnexpectedException("UTF-8 is an unsupported encoding in this JVM", exc);
        }
    }

    @Override
    public RequestBuilder apply(RequestBuilder request) {
        String token = this.constructToken(System.currentTimeMillis() / 1000L, JWTAuthMethod.constructJTI());
        request.setHeader("Authorization", "Bearer " + token);
        return request;
    }

    public String constructToken(long iat, String jti) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("iat", iat);
        claims.put("application_id", this.applicationId);
        claims.put("jti", jti);
        JWTSigner.Options options = new JWTSigner.Options().setAlgorithm(Algorithm.RS256);
        String signed = this.signer.sign(claims, options);
        return signed;
    }

    @Override
    public int getSortKey() {
        return this.SORT_KEY;
    }
}

