/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client;

import com.nexmo.client.auth.AuthCollection;
import com.nexmo.client.auth.AuthMethod;
import java.nio.charset.Charset;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpWrapper {
    private AuthCollection authCollection;
    private HttpClient httpClient = null;

    public HttpWrapper(AuthCollection authCollection) {
        this.authCollection = authCollection;
    }

    public HttpWrapper(AuthMethod ... authMethods) {
        this(new AuthCollection());
        for (AuthMethod authMethod : authMethods) {
            this.authCollection.add(authMethod);
        }
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public AuthCollection getAuthCollection() {
        return this.authCollection;
    }

    public void setAuthCollection(AuthCollection authCollection) {
        this.authCollection = authCollection;
    }

    protected HttpClient createHttpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(200);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(Charset.forName("UTF-8")).build());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
        RequestConfig requestConfig = RequestConfig.custom().build();
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setUserAgent("nexmo-java/3.3.0").setDefaultRequestConfig(requestConfig).build();
    }
}

