/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.core;

public class ExceptionUtil {
    public static final int MAX_STACK_SIZE = 10;

    public static String getErrorStack(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StackTraceElement[] stack = throwable.getStackTrace();
        return ExceptionUtil.getErrorStack(stack);
    }

    public static String getErrorStack(StackTraceElement[] stack) {
        return ExceptionUtil.getErrorStack(stack, 10);
    }

    public static String getErrorStack(StackTraceElement[] stack, Integer maxStackSize) {
        if (stack == null || stack.length == 0) {
            return null;
        }
        StringBuilder stackBuilder = new StringBuilder();
        for (int i = 0; i < Math.min(maxStackSize, stack.length); ++i) {
            stackBuilder.append("  at " + stack[i].toString() + "\n");
        }
        return stackBuilder.toString();
    }
}

