/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.SpanEventsConfig;
import com.newrelic.agent.interfaces.ReservoirManager;
import com.newrelic.agent.interfaces.SamplingPriorityQueue;
import com.newrelic.agent.interfaces.backport.Consumer;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.SpanEventCreationDecider;
import com.newrelic.agent.service.analytics.SpanEventHarvestableImpl;
import com.newrelic.agent.service.analytics.SpanEventsService;
import com.newrelic.agent.service.analytics.TracerToSpanEvent;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.HttpParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SpanEventsServiceImpl
extends AbstractService
implements AgentConfigListener,
SpanEventsService,
TransactionListener {
    private final ReservoirManager<SpanEvent> reservoirManager;
    private final ReservoirManager.EventSender<SpanEvent> collectorSender;
    private final Consumer<SpanEvent> eventBackendStorage;
    private final SpanEventCreationDecider spanEventCreationDecider;
    private final List<Harvestable> harvestables = new ArrayList<Harvestable>();
    private final TracerToSpanEvent tracerToSpanEvent;
    private volatile SpanEventsConfig spanEventsConfig;

    public SpanEventsServiceImpl(Builder builder) {
        super(SpanEventsServiceImpl.class.getSimpleName());
        this.reservoirManager = builder.reservoirManager;
        this.collectorSender = builder.collectorSender;
        this.eventBackendStorage = builder.eventBackendStorage;
        this.spanEventCreationDecider = builder.spanEventCreationDecider;
        this.tracerToSpanEvent = builder.tracerToSpanEvent;
        this.spanEventsConfig = builder.spanEventsConfig;
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        if (this.isSpanEventsEnabled() && this.spanEventCreationDecider.shouldCreateSpans(transactionData)) {
            Tracer rootTracer = transactionData.getRootTracer();
            this.storeSafely(transactionData, rootTracer, true, transactionStats);
            Collection<Tracer> tracers = transactionData.getTracers();
            for (Tracer tracer : tracers) {
                if (!tracer.isTransactionSegment()) continue;
                this.storeSafely(transactionData, tracer, false, transactionStats);
            }
        }
    }

    private void storeSafely(TransactionData transactionData, Tracer rootTracer, boolean isRoot, TransactionStats transactionStats) {
        try {
            this.createAndStoreSpanEvent(rootTracer, transactionData, isRoot, transactionStats);
        }
        catch (Throwable t2) {
            Agent.LOG.log(Level.FINER, t2, "An error occurred creating span event for tracer: {0} in tx: {1}", rootTracer, transactionData);
        }
    }

    private void createAndStoreSpanEvent(Tracer tracer, TransactionData transactionData, boolean isRoot, TransactionStats transactionStats) {
        boolean crossProcessOnly = this.spanEventsConfig.isCrossProcessOnly();
        if (crossProcessOnly && !this.isCrossProcessTracer(tracer)) {
            return;
        }
        SamplingPriorityQueue<SpanEvent> reservoir = this.getOrCreateDistributedSamplingReservoir();
        if (reservoir.isFull() && reservoir.getMinPriority() >= transactionData.getPriority()) {
            reservoir.incrementNumberOfTries();
            return;
        }
        SpanEvent spanEvent = this.tracerToSpanEvent.createSpanEvent(tracer, transactionData, transactionStats, isRoot, crossProcessOnly);
        this.storeEvent(spanEvent);
    }

    private boolean isCrossProcessTracer(Tracer tracer) {
        return tracer.getExternalParameters() instanceof HttpParameters || tracer.getExternalParameters() instanceof DatastoreParameters;
    }

    @Override
    public void harvestEvents(final String appName) {
        if (!this.spanEventsConfig.isEnabled() || this.reservoirManager.getMaxSamplesStored() <= 0) {
            this.clearReservoir();
            return;
        }
        long startTimeInNanos = System.nanoTime();
        final ReservoirManager.HarvestResult result = this.reservoirManager.attemptToSendReservoir(appName, this.collectorSender, this.logger);
        if (result != null) {
            final long durationInNanos = System.nanoTime() - startTimeInNanos;
            ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                @Override
                public void doWork(StatsEngine statsEngine) {
                    SpanEventsServiceImpl.this.recordSupportabilityMetrics(statsEngine, durationInNanos, result.sent, result.seen);
                }

                @Override
                public String getAppName() {
                    return appName;
                }
            });
        }
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanos, int numberOfEventsSent, int numberOfEventsSeen) {
        statsEngine.getStats("Supportability/SpanEvent/TotalEventsSent").incrementCallCount(numberOfEventsSent);
        statsEngine.getStats("Supportability/SpanEvent/TotalEventsSeen").incrementCallCount(numberOfEventsSeen);
        statsEngine.getStats("Supportability/SpanEvent/Discarded").incrementCallCount(numberOfEventsSeen - numberOfEventsSent);
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/SpanEvent/transmit").recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public String getEventHarvestIntervalMetric() {
        return "Supportability/EventHarvest/SpanEvent/interval";
    }

    @Override
    public String getReportPeriodInSecondsMetric() {
        return "Supportability/EventHarvest/SpanEventData/ReportPeriod";
    }

    @Override
    public String getEventHarvestLimitMetric() {
        return "Supportability/EventHarvest/SpanEventData/HarvestLimit";
    }

    @Override
    public boolean isEnabled() {
        return this.spanEventsConfig.isEnabled();
    }

    private boolean isSpanEventsEnabled() {
        return this.spanEventsConfig.isEnabled() && this.reservoirManager.getMaxSamplesStored() > 0;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isEnabled()) {
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/SpanEvents");
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        this.removeHarvestables();
        this.clearReservoir();
    }

    private void removeHarvestables() {
        for (Harvestable harvestable : this.harvestables) {
            ServiceFactory.getHarvestService().removeHarvestable(harvestable);
        }
    }

    @Override
    public void storeEvent(SpanEvent event) {
        this.eventBackendStorage.accept(event);
    }

    @Override
    public int getMaxSamplesStored() {
        return this.reservoirManager.getMaxSamplesStored();
    }

    @Override
    public void setMaxSamplesStored(int maxSamplesStored) {
        this.reservoirManager.setMaxSamplesStored(maxSamplesStored);
    }

    @Override
    public void clearReservoir() {
        this.reservoirManager.clearReservoir();
    }

    @Override
    public void addHarvestableToService(String appName) {
        String primaryApplication = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();
        if (primaryApplication.equals(appName)) {
            SpanEventHarvestableImpl harvestable = new SpanEventHarvestableImpl(this, appName);
            ServiceFactory.getHarvestService().addHarvestable(harvestable);
            this.harvestables.add(harvestable);
        }
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        boolean wasEnabled = this.isEnabled();
        this.spanEventsConfig = agentConfig.getSpanEventsConfig();
        if (!wasEnabled && this.isEnabled()) {
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/SpanEvents");
        }
    }

    @Override
    public SamplingPriorityQueue<SpanEvent> getOrCreateDistributedSamplingReservoir() {
        return this.reservoirManager.getOrCreateReservoir();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AgentConfig agentConfig;
        private ReservoirManager<SpanEvent> reservoirManager;
        private ReservoirManager.EventSender<SpanEvent> collectorSender;
        private Consumer<SpanEvent> eventBackendStorage;
        private SpanEventCreationDecider spanEventCreationDecider;
        private SpanEventsConfig spanEventsConfig;
        private TracerToSpanEvent tracerToSpanEvent;

        public Builder agentConfig(AgentConfig agentConfig) {
            this.agentConfig = agentConfig;
            return this;
        }

        public Builder reservoirManager(ReservoirManager<SpanEvent> reservoirManager) {
            this.reservoirManager = reservoirManager;
            return this;
        }

        public Builder collectorSender(ReservoirManager.EventSender<SpanEvent> collectorSender) {
            this.collectorSender = collectorSender;
            return this;
        }

        public Builder eventBackendStorage(Consumer<SpanEvent> eventBackendStorage) {
            this.eventBackendStorage = eventBackendStorage;
            return this;
        }

        public Builder spanEventCreationDecider(SpanEventCreationDecider decider) {
            this.spanEventCreationDecider = decider;
            return this;
        }

        public Builder spanEventsConfig(SpanEventsConfig spanEventsConfig) {
            this.spanEventsConfig = spanEventsConfig;
            return this;
        }

        public Builder tracerToSpanEvent(TracerToSpanEvent tracerToSpanEvent) {
            this.tracerToSpanEvent = tracerToSpanEvent;
            return this;
        }

        public SpanEventsServiceImpl build() {
            if (this.spanEventsConfig == null) {
                this.spanEventsConfig = this.agentConfig.getSpanEventsConfig();
            }
            return new SpanEventsServiceImpl(this);
        }
    }
}

