/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.method;

import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.profile.MethodLineNumberMatcher;
import com.newrelic.agent.profile.method.ExactMethodInfo;
import com.newrelic.agent.profile.method.MethodInfo;
import com.newrelic.agent.profile.method.MultipleMethodInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MethodInfoUtil {
    public static MethodInfo createMethodInfo(Class<?> declaringClass, String methodName, int lineNumber) {
        String methodDesc = MethodLineNumberMatcher.getMethodDescription(declaringClass, methodName, lineNumber);
        return MethodInfoUtil.getMethodInfo(declaringClass, methodName, methodDesc);
    }

    protected static MethodInfo getMethodInfo(Class<?> declaringClass, String methodName, String methodDesc) {
        if (methodDesc == null) {
            return MethodInfoUtil.handleNoMethodDesc(declaringClass, methodName);
        }
        List<String> args2 = MethodInfoUtil.getArguments(methodDesc);
        if (MethodInfoUtil.isConstructor(methodName)) {
            return MethodInfoUtil.handleConstructor(declaringClass, methodName, methodDesc, args2);
        }
        return MethodInfoUtil.handleMethod(declaringClass, methodName, methodDesc, args2);
    }

    private static MethodInfo handleMethod(Class<?> declaringClass, String methodName, String methodDesc, List<String> args2) {
        ArrayList<Member> members = new ArrayList<Member>();
        if (MethodInfoUtil.getMethod(members, declaringClass, methodName, args2)) {
            return new ExactMethodInfo(args2, (Member)members.get(0));
        }
        return new MultipleMethodInfo(new HashSet<Member>(members));
    }

    private static MethodInfo handleConstructor(Class<?> declaringClass, String methodName, String methodDesc, List<String> args2) {
        ArrayList<Member> members = new ArrayList<Member>();
        if (MethodInfoUtil.getConstructor(members, declaringClass, methodName, args2)) {
            return new ExactMethodInfo(args2, (Member)members.get(0));
        }
        return new MultipleMethodInfo(new HashSet<Member>(members));
    }

    private static MethodInfo handleNoMethodDesc(Class<?> declaringClass, String methodName) {
        if (MethodInfoUtil.isConstructor(methodName)) {
            return new MultipleMethodInfo(Sets.newHashSet(declaringClass.getDeclaredConstructors()));
        }
        return new MultipleMethodInfo(MethodInfoUtil.getMatchingMethods(declaringClass, methodName));
    }

    protected static List<String> getArguments(Member m4) {
        ArrayList<String> paramClasses = new ArrayList<String>();
        Class<Object>[] params = m4 instanceof Method ? ((Method)m4).getParameterTypes() : (m4 instanceof Constructor ? ((Constructor)m4).getParameterTypes() : new Class[]{});
        for (Class<?> clazz : params) {
            paramClasses.add(MethodInfoUtil.getClassName(clazz));
        }
        return paramClasses;
    }

    protected static List<String> getArguments(String methodDesc) {
        Type[] types = Type.getArgumentTypes(methodDesc);
        ArrayList<String> args2 = new ArrayList<String>(types.length);
        for (Type current : types) {
            args2.add(current.getClassName());
        }
        return args2;
    }

    private static boolean isConstructor(String methodName) {
        return methodName.startsWith("<");
    }

    private static boolean getConstructor(List<Member> addToHere, Class<?> declaringClass, String constName, List<String> arguments) {
        for (Constructor<?> constructor : declaringClass.getDeclaredConstructors()) {
            addToHere.add(constructor);
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != arguments.size()) continue;
            boolean matches = true;
            for (int i = 0; i < params.length; ++i) {
                if (arguments.get(i).equals(MethodInfoUtil.getClassName(params[i]))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            addToHere.clear();
            addToHere.add(constructor);
            return true;
        }
        return false;
    }

    static String getClassName(Class<?> clazz) {
        String paramName = null;
        try {
            paramName = clazz.getCanonicalName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == paramName) {
            return clazz.getName();
        }
        return paramName;
    }

    protected static boolean getMethod(List<Member> addToHere, Class<?> declaringClass, String methodName, List<String> arguments) {
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            addToHere.add(method);
            Class<?>[] params = method.getParameterTypes();
            if (params.length != arguments.size()) continue;
            boolean matches = true;
            for (int i = 0; i < params.length; ++i) {
                if (arguments.get(i).equals(MethodInfoUtil.getClassName(params[i]))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            addToHere.clear();
            addToHere.add(method);
            return true;
        }
        return false;
    }

    protected static Set<Member> getMatchingMethods(Class<?> declaringClass, String methodName) {
        HashSet<Member> methods = new HashSet<Member>();
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            methods.add(method);
        }
        return methods;
    }
}

