/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.tracing;

import com.newrelic.agent.bridge.ExitTracer;
import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.bridge.NoOpTracedMethod;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.tracing.NoticeSqlVisitor;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ClassMethodSignatures;
import com.newrelic.agent.tracers.SqlTracer;
import com.newrelic.agent.util.asm.BytecodeGenProxyBuilder;
import com.newrelic.agent.util.asm.Variables;
import java.util.Iterator;
import java.util.Map;

public class TraceMethodVisitor
extends AdviceAdapter {
    protected final Method method;
    private final int tracerLocal;
    private final Label startFinallyLabel;
    private final TraceDetails traceDetails;
    private final int access;
    private final boolean customTracer;
    private final boolean noticeSql;
    protected final String className;
    private final int signatureId;
    static final Type TRACER_TYPE = Type.getType(ExitTracer.class);
    static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    public static final Method IGNORE_APDEX_METHOD = new Method("ignoreApdex", Type.VOID_TYPE, new Type[0]);

    public TraceMethodVisitor(String className, MethodVisitor mv, int access, String name, String desc, TraceDetails trace, boolean customTracer, boolean noticeSql, Class<?> classBeingRedefined) {
        super(589824, mv, access, name, desc);
        this.className = className.replace('/', '.');
        this.method = new Method(name, desc);
        this.access = access;
        this.customTracer = customTracer;
        this.noticeSql = noticeSql;
        this.startFinallyLabel = new Label();
        this.tracerLocal = this.newLocal(TRACER_TYPE);
        this.traceDetails = trace;
        int signatureId = -1;
        ClassMethodSignature signature = new ClassMethodSignature(this.className.intern(), this.method.getName().intern(), this.methodDesc.intern());
        if (classBeingRedefined != null) {
            signatureId = ClassMethodSignatures.get().getIndex(signature);
        }
        if (signatureId == -1) {
            signatureId = ClassMethodSignatures.get().add(signature);
        }
        this.signatureId = signatureId;
    }

    @Override
    protected void onMethodEnter() {
        super.onMethodEnter();
        this.startTracer();
    }

    protected void startTracer() {
        this.visitInsn(1);
        this.storeLocal(this.tracerLocal, TRACER_TYPE);
        this.visitLabel(this.startFinallyLabel);
        Label start = new Label();
        Label end = new Label();
        Label handler = new Label();
        this.visitTryCatchBlock(start, end, handler, THROWABLE_TYPE.getInternalName());
        this.visitLabel(start);
        super.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
        String metricName = this.traceDetails.getFullMetricName(this.className, this.method.getName());
        String tracerFactory = this.traceDetails.tracerFactoryName();
        BytecodeGenProxyBuilder<Instrumentation> builder = BytecodeGenProxyBuilder.newBuilder(Instrumentation.class, this, true);
        Variables loader = builder.getVariables();
        Instrumentation instrumentation = builder.build();
        if (tracerFactory == null) {
            int tracerFlags = this.getTracerFlags();
            if (this.noticeSql) {
                instrumentation.createSqlTracer(loader.loadThis(this.access), this.signatureId, metricName, tracerFlags);
            } else {
                instrumentation.createTracer(loader.loadThis(this.access), this.signatureId, metricName, tracerFlags);
            }
        } else {
            Object[] loadArgs = loader.load(Object[].class, new Runnable(){

                @Override
                public void run() {
                    TraceMethodVisitor.this.loadArgArray();
                }
            });
            instrumentation.createTracer(loader.loadThis(this.access), this.signatureId, this.traceDetails.dispatcher(), metricName, tracerFactory, loadArgs);
        }
        this.storeLocal(this.tracerLocal, TRACER_TYPE);
        this.goTo(end);
        this.visitLabel(handler);
        this.pop();
        this.visitLabel(end);
    }

    private int getTracerFlags() {
        int tracerFlags = 2;
        if (this.traceDetails.dispatcher()) {
            tracerFlags |= 8;
        }
        if (this.traceDetails.async()) {
            tracerFlags |= 0x40;
        }
        if (this.traceDetails.isLeaf()) {
            tracerFlags |= 0x20;
        }
        if (!this.traceDetails.excludeFromTransactionTrace()) {
            tracerFlags |= 4;
        }
        if (this.customTracer) {
            tracerFlags |= 0x10;
        }
        return tracerFlags;
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinallyLabel = new Label();
        super.visitTryCatchBlock(this.startFinallyLabel, endFinallyLabel, endFinallyLabel, THROWABLE_TYPE.getInternalName());
        super.visitLabel(endFinallyLabel);
        this.onEveryExit(191);
        super.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onEveryExit(opcode);
        }
    }

    protected void onEveryExit(int opcode) {
        Label isTracerNullLabel = new Label();
        this.loadLocal(this.tracerLocal);
        this.ifNull(isTracerNullLabel);
        if (191 == opcode) {
            this.dup();
        }
        this.loadLocal(this.tracerLocal);
        ExitTracer tracer = BytecodeGenProxyBuilder.newBuilder(ExitTracer.class, this, false).build();
        if (191 == opcode) {
            this.swap();
            tracer.finish(null);
        } else {
            this.push(opcode);
            this.visitInsn(1);
            tracer.finish(0, null);
        }
        this.visitLabel(isTracerNullLabel);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (owner.equals(BridgeUtils.TRACED_METHOD_TYPE.getInternalName())) {
            this.loadTracer();
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (BridgeUtils.isAgentType(owner) && "getTracedMethod".equals(name)) {
            this.pop();
            this.loadTracer();
        } else if (NoticeSqlVisitor.isNoticeSqlMethod(owner, name, desc)) {
            this.rewriteNoticeSqlCall();
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private void rewriteNoticeSqlCall() {
        Label doWorkLabel = this.newLabel();
        Label endLabel = this.newLabel();
        int parameterCount = NoticeSqlVisitor.getSqlTracerSettersCount();
        this.skipIfNotSqlTracer(parameterCount, doWorkLabel, endLabel);
        this.visitLabel(doWorkLabel);
        this.setSqlTracerData();
        this.visitLabel(endLabel);
    }

    private void skipIfNotSqlTracer(int parameterCount, Label doWorkLabel, Label endLabel) {
        this.loadTracer();
        this.instanceOf(Type.getType(SqlTracer.class));
        this.ifZCmp(154, doWorkLabel);
        for (int i = 0; i < parameterCount; ++i) {
            this.pop();
        }
        this.goTo(endLabel);
    }

    private void setSqlTracerData() {
        Iterator<Map.Entry<String, Type>> iterator2 = NoticeSqlVisitor.getSqlTracerSettersInReverseOrder();
        while (iterator2.hasNext()) {
            Map.Entry<String, Type> entry = iterator2.next();
            this.loadTracer();
            this.swap();
            this.invokeInterface(Type.getType(SqlTracer.class), new Method(entry.getKey(), Type.VOID_TYPE, new Type[]{entry.getValue()}));
        }
    }

    private void loadTracer() {
        Label isTracerNullLabel = new Label();
        Label end = new Label();
        this.loadLocal(this.tracerLocal);
        this.ifNull(isTracerNullLabel);
        this.loadLocal(this.tracerLocal);
        this.goTo(end);
        this.visitLabel(isTracerNullLabel);
        this.getStatic(Type.getType(NoOpTracedMethod.class), "INSTANCE", Type.getType(TracedMethod.class));
        this.visitLabel(end);
    }
}

