/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.TracerService;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.errors.ErrorServiceImpl;
import com.newrelic.agent.instrumentation.AgentWrapper;
import com.newrelic.agent.instrumentation.ClassNameFilter;
import com.newrelic.agent.instrumentation.GenericClassAdapter;
import com.newrelic.agent.instrumentation.IgnoreApdexInvocationHandler;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InvocationPoint;
import com.newrelic.agent.instrumentation.NoOpInvocationHandler;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcherBuilder;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.util.Annotations;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationHandler;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class PointCutClassTransformer
implements ContextClassTransformer {
    private static final String[] LEGACY_POINTCUT_EXCLUDES = new String[]{"^(java/|sun/|com/sun/|com/newrelic/agent/|com/newrelic/org/)(.*)", "^org/apache/catalina/startup/Bootstrap", "^com/ibm/ws/webcontainer/servlet/ServletWrapper"};
    protected final Collection<PointCut> pointcuts;
    private final int classreaderFlags;
    private final InstrumentationProxy instrumentation;
    private final boolean retransformSupported;
    private final ClassNameFilter classNameFilter;
    private final IAgentLogger logger;
    private final ClassMatchVisitorFactory matcher;

    protected PointCutClassTransformer(InstrumentationProxy pInstrumentation, boolean pRetransformSupported) {
        this.instrumentation = pInstrumentation;
        this.logger = Agent.LOG.getChildLogger(PointCutClassTransformer.class);
        this.initAgentHandle();
        this.classNameFilter = new ClassNameFilter(this.logger);
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.classNameFilter.addConfigClassFilters(config);
        this.classNameFilter.addExcludeFileClassFilters();
        for (String legacyPointCutExclude : LEGACY_POINTCUT_EXCLUDES) {
            this.classNameFilter.addExclude(legacyPointCutExclude);
        }
        this.classreaderFlags = this.instrumentation.getClassReaderFlags();
        this.retransformSupported = pRetransformSupported;
        LinkedList<PointCut> pcs = new LinkedList<PointCut>(this.findEnabledPointCuts());
        pcs.addAll(ErrorServiceImpl.getEnabledErrorHandlerPointCuts());
        Collections.sort(pcs);
        this.pointcuts = Collections.unmodifiableCollection(pcs);
        this.setPointcutProperties();
        this.matcher = OptimizedClassMatcherBuilder.newBuilder().addClassMethodMatcher(this.pointcuts.toArray(new PointCut[0])).build();
    }

    public ClassMatchVisitorFactory getMatcher() {
        return this.matcher;
    }

    private void setPointcutProperties() {
        ArrayList<PointCutInvocationHandler> handlers = new ArrayList<PointCutInvocationHandler>(this.pointcuts.size());
        ArrayList<ClassMatcher> classMatchers = new ArrayList<ClassMatcher>();
        for (PointCut pc : this.pointcuts) {
            handlers.add(pc.getPointCutInvocationHandler());
            classMatchers.add(pc.getClassMatcher());
        }
        this.classNameFilter.addClassMatcherIncludes(classMatchers);
        ServiceFactory.getTracerService().registerInvocationHandlers(handlers);
        this.logger.finer("A Class transformer is initialized");
    }

    private void initAgentHandle() {
        AgentBridge.agentHandler = AgentWrapper.getAgentWrapper(this);
    }

    Collection<PointCut> findEnabledPointCuts() {
        Collection<Class<?>> classes = new Annotations().getPointCutAnnotatedClasses();
        ArrayList<PointCut> pointcuts = new ArrayList<PointCut>();
        for (Class<?> clazz : classes) {
            PointCut pc;
            if (!PointCut.class.isAssignableFrom(clazz) || (pc = this.createPointCut(clazz.asSubclass(PointCut.class))) == null || !pc.isEnabled()) continue;
            pointcuts.add(pc);
        }
        return pointcuts;
    }

    private PointCut createPointCut(Class<? extends PointCut> clazz) {
        try {
            return clazz.getConstructor(PointCutClassTransformer.class).newInstance(this);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to create pointcut {0} : {1}", clazz.getName(), e.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINE, msg, e);
            return null;
        }
    }

    public Collection<PointCut> getPointcuts() {
        return this.pointcuts;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        if (!PointCutClassTransformer.isValidClassName(className)) {
            return null;
        }
        if (!this.shouldTransform(loader, className, classfileBuffer)) {
            this.logger.trace(MessageFormat.format("PointCutTransformer Skipped instrumenting {0}", className));
            return null;
        }
        try {
            WeavingLoaderImpl weavingLoader = this.getWeavingLoader(loader);
            if (Agent.isDebugEnabled() && this.logger.isTraceEnabled()) {
                this.logger.trace(MessageFormat.format("Considering instrumenting {0}", className));
            }
            return weavingLoader.preProcess(context, className, classBeingRedefined, classfileBuffer, match);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.severe(MessageFormat.format("An error occurred processing class {0} : {1}", className, e.toString()));
            if (Agent.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected boolean shouldTransform(ClassLoader loader, String className, byte[] classfileBuffer) {
        boolean isLoggable;
        boolean bl = isLoggable = Agent.isDebugEnabled() && this.logger.isLoggable(Level.FINEST);
        if (this.isIncluded(className)) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("PointCutTransformer Class {0} is explicitly included", className));
            }
            return true;
        }
        if (this.isExcluded(className)) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("PointCutTransformer Skipping class {0} because it is excluded", className));
            }
            return false;
        }
        if (className.startsWith("$")) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("PointCutTransformer Skipping class {0} because it starts with $", className));
            }
            return false;
        }
        if (className.indexOf("$$") > 0 && !className.startsWith("play")) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("PointCutTransformer Skipping class {0} because it contains $$ and is not a Play class", className));
            }
            return false;
        }
        if (this.isValidClassByteArray(classfileBuffer)) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("PointCutTransformer Skipping class {0} because it does not appear to be a valid class file", className));
            }
            return false;
        }
        if (loader == null && !this.isBootstrapClassInstrumentationEnabled()) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("PointCutTransformer Skipping class {0} because bootstrap class instrumentation is not supported", className));
            }
            return false;
        }
        return true;
    }

    private boolean isBootstrapClassInstrumentationEnabled() {
        return this.instrumentation.isBootstrapClassInstrumentationEnabled();
    }

    protected boolean isIncluded(String className) {
        return this.classNameFilter.isIncluded(className);
    }

    protected boolean isExcluded(String className) {
        return this.classNameFilter.isExcluded(className);
    }

    protected boolean isRetransformSupported() {
        return this.retransformSupported;
    }

    private boolean isValidClassByteArray(byte[] classfileBuffer) {
        return classfileBuffer.length >= 4 && classfileBuffer[0] == -54 && classfileBuffer[0] == -2 && classfileBuffer[0] == -70 && classfileBuffer[0] == -66;
    }

    protected int getClassReaderFlags() {
        return this.classreaderFlags;
    }

    protected WeavingLoaderImpl getWeavingLoader(ClassLoader loader) {
        return new WeavingLoaderImpl(loader);
    }

    protected WeavingLoaderImpl getWeavingLoader(ClassLoader loader, boolean pIsRetrans) {
        return new WeavingLoaderImpl(loader);
    }

    InstrumentationProxy getInstrumentation() {
        return this.instrumentation;
    }

    public final ClassNameFilter getClassNameFilter() {
        return this.classNameFilter;
    }

    public InvocationHandler evaluate(Class clazz, TracerService tracerService, Object className, Object methodName, Object methodDesc, boolean ignoreApdex, Object[] args2) {
        ClassMethodSignature classMethodSignature = new ClassMethodSignature(((String)className).replace('/', '.'), (String)methodName, (String)methodDesc);
        for (PointCut pc : this.getPointcuts()) {
            if (!pc.getClassMatcher().isMatch(clazz) || !pc.getMethodMatcher().matches(-1, classMethodSignature.getMethodName(), classMethodSignature.getMethodDesc(), MethodMatcher.UNSPECIFIED_ANNOTATIONS)) continue;
            PointCutInvocationHandler invocationHandler = pc.getPointCutInvocationHandler();
            return InvocationPoint.getInvocationPoint(invocationHandler, tracerService, classMethodSignature, ignoreApdex);
        }
        if (ignoreApdex) {
            return IgnoreApdexInvocationHandler.INVOCATION_HANDLER;
        }
        Agent.LOG.log(Level.FINE, "No invocation handler was registered for {0}", classMethodSignature);
        return NoOpInvocationHandler.INVOCATION_HANDLER;
    }

    public static boolean isInstrumented(Class<?> clazz) {
        return clazz.getAnnotation(InstrumentedClass.class) != null;
    }

    public static boolean isInstrumentedAndModified(Class<?> clazz) {
        if (clazz.getAnnotation(InstrumentedClass.class) != null) {
            return clazz.getAnnotation(InstrumentedClass.class).classStructureModified();
        }
        return false;
    }

    public static boolean canModifyClassStructure(ClassLoader classLoader, Class<?> classBeingRedefined) {
        return !PointCutClassTransformer.hasBeenLoaded(classBeingRedefined) || PointCutClassTransformer.isInstrumentedAndModified(classBeingRedefined);
    }

    public static boolean hasBeenLoaded(Class<?> clazz) {
        return null != clazz;
    }

    public static boolean isValidClassName(String className) {
        return className != null;
    }

    class WeavingLoaderImpl {
        private final ClassLoader classLoader;

        public WeavingLoaderImpl(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public byte[] preProcess(InstrumentationContext context, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, OptimizedClassMatcher.Match match) {
            ClassReader cr = new ClassReader(classfileBuffer);
            if (InstrumentationUtils.isInterface(cr)) {
                return null;
            }
            ArrayList<PointCut> strongMatches = new ArrayList<PointCut>(PointCutClassTransformer.this.pointcuts);
            strongMatches.retainAll(match.getClassMatches().keySet());
            if (strongMatches.isEmpty()) {
                return null;
            }
            if (this.classLoader != null && !InstrumentationUtils.isAbleToResolveAgent(this.classLoader, className)) {
                String msg = MessageFormat.format("Not instrumenting {0}: class loader unable to load agent classes", className);
                Agent.LOG.log(Level.FINER, msg);
                return null;
            }
            try {
                if (PointCutClassTransformer.canModifyClassStructure(this.classLoader, classBeingRedefined)) {
                    byte[] classfileBufferWithUID = InstrumentationUtils.generateClassBytesWithSerialVersionUID(cr, PointCutClassTransformer.this.classreaderFlags, this.classLoader);
                    cr = new ClassReader(classfileBufferWithUID);
                }
                ClassWriter cw = InstrumentationUtils.getClassWriter(cr, this.classLoader);
                GenericClassAdapter adapter = new GenericClassAdapter(cw, this.classLoader, className, classBeingRedefined, strongMatches, context);
                cr.accept(adapter, PointCutClassTransformer.this.classreaderFlags);
                if (adapter.getInstrumentedMethods().size() > 0) {
                    if (Agent.LOG.isFinerEnabled()) {
                        String msg = MessageFormat.format("Instrumenting {0}", className);
                        Agent.LOG.finer(msg);
                    }
                    this.recordSupportabilityMetrics(adapter.getAppliedPointCuts());
                    return cw.toByteArray();
                }
                return null;
            }
            catch (StopProcessingException e) {
                return null;
            }
            catch (ArrayIndexOutOfBoundsException t2) {
                String msg = MessageFormat.format("Skipping transformation of class {0} ({1} bytes) because an ASM array bounds exception occurred: {2}", className, classfileBuffer.length, t2.toString());
                PointCutClassTransformer.this.logger.warning(msg);
                if (PointCutClassTransformer.this.logger.isLoggable(Level.FINER)) {
                    msg = MessageFormat.format("ASM error for pointcut(s) : strong {0}", strongMatches);
                    PointCutClassTransformer.this.logger.finer(msg);
                    PointCutClassTransformer.this.logger.log(Level.FINER, "ASM error", t2);
                }
                if (Boolean.getBoolean("newrelic.asm.error.stop")) {
                    System.exit(-1);
                }
                return null;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t3) {
                PointCutClassTransformer.this.logger.warning(MessageFormat.format("Skipping transformation of class {0} because an error occurred: {1}", className, t3.toString()));
                if (PointCutClassTransformer.this.logger.isLoggable(Level.FINER)) {
                    PointCutClassTransformer.this.logger.log(Level.FINER, "Error transforming class " + className, t3);
                }
                return null;
            }
        }

        private void recordSupportabilityMetrics(List<PointCut> appliedPointCuts) {
            for (PointCut pointCut : appliedPointCuts) {
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format("Supportability/PointCutInstrumentation/Loaded/{0}", pointCut.getName()), 1.0f));
            }
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

