/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.discovery;

import com.newrelic.agent.discovery.Externalizable;
import com.newrelic.agent.discovery.StatusMessage;
import com.newrelic.agent.discovery.StatusMessageWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class StatusClient
implements StatusMessageWriter {
    private final int port;
    private final InetAddress address;

    private StatusClient(int port) throws UnknownHostException {
        this.port = port;
        this.address = InetAddress.getLocalHost();
    }

    public static StatusClient create(int port) throws UnknownHostException {
        return new StatusClient(port);
    }

    @Override
    public void write(StatusMessage message) throws IOException {
        this.write(-1921492641455922593L, message);
    }

    private void write(long uid, Externalizable externalizable) throws IOException {
        try (Socket socket = new Socket(this.address, this.port);){
            socket.setSoLinger(true, 1);
            try (ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());){
                out.writeLong(uid);
                externalizable.writeExternal(out);
            }
        }
    }
}

