/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.jregex;

import com.newrelic.agent.deps.jregex.Matcher;
import com.newrelic.agent.deps.jregex.Pattern;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class RETokenizer
implements Enumeration {
    private Matcher matcher;
    private boolean checked;
    private boolean hasToken;
    private String token;
    private int pos = 0;
    private boolean endReached = false;
    private boolean emptyTokensEnabnled = false;

    public RETokenizer(Pattern pattern, String text) {
        this(pattern.matcher(text), false);
    }

    public RETokenizer(Pattern pattern, char[] chars, int off, int len) {
        this(pattern.matcher(chars, off, len), false);
    }

    public RETokenizer(Pattern pattern, Reader r, int len) throws IOException {
        this(pattern.matcher(r, len), false);
    }

    public RETokenizer(Matcher m4, boolean emptyEnabled) {
        this.matcher = m4;
        this.emptyTokensEnabnled = emptyEnabled;
    }

    public void setEmptyEnabled(boolean b) {
        this.emptyTokensEnabnled = b;
    }

    public boolean isEmptyEnabled() {
        return this.emptyTokensEnabnled;
    }

    public boolean hasMore() {
        if (!this.checked) {
            this.check();
        }
        return this.hasToken;
    }

    public String nextToken() {
        if (!this.checked) {
            this.check();
        }
        if (!this.hasToken) {
            throw new NoSuchElementException();
        }
        this.checked = false;
        return this.token;
    }

    public String[] split() {
        return RETokenizer.collect(this, null, 0);
    }

    public void reset() {
        this.matcher.setPosition(0);
    }

    private static final String[] collect(RETokenizer tok, String[] arr, int count) {
        if (tok.hasMore()) {
            String s2 = tok.nextToken();
            arr = RETokenizer.collect(tok, arr, count + 1);
            arr[count] = s2;
        } else {
            arr = new String[count];
        }
        return arr;
    }

    private void check() {
        boolean emptyOk = this.emptyTokensEnabnled;
        this.checked = true;
        if (this.endReached) {
            this.hasToken = false;
            return;
        }
        Matcher m4 = this.matcher;
        boolean hasMatch = false;
        while (m4.find()) {
            if (m4.start() > 0) {
                hasMatch = true;
                break;
            }
            if (m4.end() <= 0) continue;
            if (emptyOk) {
                hasMatch = true;
                break;
            }
            m4.setTarget(m4, -2);
        }
        if (!hasMatch) {
            this.endReached = true;
            if (m4.length(-3) == 0 && !emptyOk) {
                this.hasToken = false;
            } else {
                this.hasToken = true;
                this.token = m4.target();
            }
            return;
        }
        this.hasToken = true;
        this.token = m4.prefix();
        m4.setTarget(m4, -2);
    }

    public boolean hasMoreElements() {
        return this.hasMore();
    }

    public Object nextElement() {
        return this.nextToken();
    }
}

