/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.IBMUtils;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.deps.org.json.simple.parser.ParseException;
import com.newrelic.agent.discovery.AgentArguments;
import com.newrelic.agent.discovery.StatusClient;
import com.newrelic.agent.discovery.StatusMessage;
import com.newrelic.agent.service.ServiceManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class LifecycleObserver {
    protected LifecycleObserver() {
    }

    void agentStarted() {
    }

    void serviceManagerStarted(ServiceManager serviceManager) {
    }

    void agentAlreadyRunning() {
    }

    public boolean isAgentSafe() {
        return true;
    }

    public static LifecycleObserver createLifecycleObserver(String agentArgs) {
        if (agentArgs != null && !agentArgs.isEmpty()) {
            try {
                AgentArguments args2 = AgentArguments.fromJsonObject(new JSONParser().parse(agentArgs));
                Number port = args2.getServerPort();
                StatusClient client = StatusClient.create(port.intValue());
                client.write(StatusMessage.info(args2.getId(), "Msg", "Initializing agent"));
                return new AttachLifecycleObserver(client, args2);
            }
            catch (ParseException | IOException exception) {
                // empty catch block
            }
        }
        return new LifecycleObserver();
    }

    private static class AttachLifecycleObserver
    extends LifecycleObserver {
        private final StatusClient client;
        private final AtomicReference<ServiceManager> serviceManager = new AtomicReference();
        private final String id;

        public AttachLifecycleObserver(StatusClient client, AgentArguments args2) {
            this.client = client;
            this.id = args2.getId();
        }

        @Override
        public boolean isAgentSafe() {
            if (IBMUtils.isIbmJVM() && !Boolean.parseBoolean(SystemPropertyFactory.getSystemPropertyProvider().getSystemProperty("newrelic.try_ibm_attach"))) {
                this.writeMessage(StatusMessage.error(this.id, "Error", "The agent attach feature is not supported for IBM JVMs"));
                return false;
            }
            return true;
        }

        @Override
        void agentStarted() {
            this.writeMessage(StatusMessage.warn(this.id, "Msg", "The agent has started and is connecting to New Relic. This may take a few minutes."));
            while (!this.writeConnectMessage()) {
                try {
                    TimeUnit.SECONDS.sleep(30L);
                    this.writeMessage(StatusMessage.warn(this.id, "Msg", "Establishing a connection with New Relic..."));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean writeConnectMessage() {
            ServiceManager serviceManager = this.serviceManager.get();
            if (serviceManager != null) {
                IRPMService rpmService = serviceManager.getRPMServiceManager().getRPMService();
                if (rpmService.isStoppedOrStopping()) {
                    this.writeMessage(StatusMessage.error(this.id, "Error", "The agent has shutdown. Make sure that the license key matches the region."));
                    return true;
                }
                if (rpmService.isConnected()) {
                    this.writeMessage(StatusMessage.success(this.id, rpmService.getApplicationLink()));
                    return true;
                }
            }
            return false;
        }

        private void writeMessage(StatusMessage message) {
            try {
                System.out.println(message);
                this.client.write(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void serviceManagerStarted(ServiceManager serviceManager) {
            this.serviceManager.set(serviceManager);
        }

        @Override
        public void agentAlreadyRunning() {
            this.writeMessage(StatusMessage.error(this.id, "Error", "The New Relic agent is already attached to this process"));
        }
    }
}

