/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.CloudVendor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class AWS
implements CloudVendor {
    static String PROVIDER = "aws";
    private final CloudUtility cloudUtility;
    private static final String INSTANCE_TOKEN_URL = "http://169.254.169.254/latest/api/token";
    private static final String INSTANCE_DOCUMENT_URL = "http://169.254.169.254/2016-09-02/dynamic/instance-identity/document";
    private static final int REQUEST_TIMEOUT_MILLIS = 100;
    private static final int TOKEN_TTL_SECONDS = 60;
    private static final String AWS_INSTANCE_ID_REQUEST = "instanceId";
    private static final String AWS_INSTANCE_TYPE_REQUEST = "instanceType";
    private static final String AWS_AVAILABILITY_ZONE_REQUEST = "availabilityZone";
    private static final String AWS_INSTANCE_ID_KEY = "instanceId";
    private static final String AWS_INSTANCE_TYPE_KEY = "instanceType";
    private static final String AWS_AVAILABILITY_ZONE_KEY = "availabilityZone";

    public AWS(CloudUtility cloudUtility) {
        this.cloudUtility = cloudUtility;
    }

    @Override
    public AwsData getData() {
        String token = this.getAwsToken();
        if (token == null || token.isEmpty()) {
            return AwsData.EMPTY_DATA;
        }
        try {
            String unparsedResult = this.getAwsValues(token);
            JSONParser parser = new JSONParser();
            HashMap result = null;
            if (unparsedResult != null) {
                result = (JSONObject)parser.parse(unparsedResult);
            }
            if (result == null || result.isEmpty()) {
                return AwsData.EMPTY_DATA;
            }
            String type = (String)result.get("instanceType");
            String id = (String)result.get("instanceId");
            String zone = (String)result.get("availabilityZone");
            if (this.cloudUtility.isInvalidValue(type) || this.cloudUtility.isInvalidValue(id) || this.cloudUtility.isInvalidValue(zone)) {
                Agent.LOG.log(Level.WARNING, "Failed to validate AWS value");
                this.recordAwsError();
                return AwsData.EMPTY_DATA;
            }
            AwsData data = new AwsData(id, type, zone);
            Agent.LOG.log(Level.FINEST, "Found {0}", data);
            return data;
        }
        catch (Exception e) {
            return AwsData.EMPTY_DATA;
        }
    }

    private String getAwsToken() {
        try {
            return this.cloudUtility.httpPut(INSTANCE_TOKEN_URL, 100, "X-aws-ec2-metadata-token-ttl-seconds: 60");
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, t, "Error occurred trying to get AWS token");
            this.recordAwsError();
            return null;
        }
    }

    private String getAwsValues(String token) {
        try {
            return this.cloudUtility.httpGet(INSTANCE_DOCUMENT_URL, 100, "X-aws-ec2-metadata-token: " + token);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Error occurred trying to get AWS values. {0}", t));
            this.recordAwsError();
            return null;
        }
    }

    private void recordAwsError() {
        this.cloudUtility.recordError("Supportability/utilization/aws/error");
    }

    protected static class AwsData
    implements CloudData {
        private final String instanceId;
        private final String instanceType;
        private final String availabilityZone;
        static final AwsData EMPTY_DATA = new AwsData();

        private AwsData() {
            this.instanceId = null;
            this.instanceType = null;
            this.availabilityZone = null;
        }

        protected AwsData(String id, String type, String zone) {
            this.instanceId = id;
            this.instanceType = type;
            this.availabilityZone = zone;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public Map<String, String> getValueMap() {
            HashMap<String, String> aws = new HashMap<String, String>();
            if (this.instanceType == null || this.instanceId == null || this.availabilityZone == null) {
                return aws;
            }
            aws.put("instanceType", this.instanceType);
            aws.put("instanceId", this.instanceId);
            aws.put("availabilityZone", this.availabilityZone);
            return aws;
        }

        @Override
        public String getProvider() {
            return PROVIDER;
        }

        @Override
        public boolean isEmpty() {
            return this == EMPTY_DATA;
        }

        public String toString() {
            return "AwsData{instanceId='" + this.instanceId + '\'' + ", instanceType='" + this.instanceType + '\'' + ", availabilityZone='" + this.availabilityZone + '\'' + '}';
        }
    }
}

