/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Cache;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.tracers.MetricNameFormatWithHost;
import java.net.URL;

public class TransactionCache {
    private Cache<Object, URL> urlCache;
    private Cache<Object, MetricNameFormatWithHost> inputStreamCache;

    public MetricNameFormatWithHost getMetricNameFormatWithHost(Object key) {
        return this.getInputStreamCache().getIfPresent(key);
    }

    public void putMetricNameFormatWithHost(Object key, MetricNameFormatWithHost val) {
        this.getInputStreamCache().put(key, val);
    }

    private Cache<Object, MetricNameFormatWithHost> getInputStreamCache() {
        if (this.inputStreamCache == null) {
            this.inputStreamCache = Caffeine.newBuilder().weakKeys().build();
        }
        return this.inputStreamCache;
    }

    public URL getURL(Object key) {
        return this.getUrlCache().getIfPresent(key);
    }

    public void putURL(Object key, URL val) {
        this.getUrlCache().put(key, val);
    }

    private Cache<Object, URL> getUrlCache() {
        if (this.urlCache == null) {
            this.urlCache = Caffeine.newBuilder().weakKeys().build();
        }
        return this.urlCache;
    }
}

