/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.model.ApdexPerfZone;
import com.newrelic.agent.stats.ApdexPerfZoneDetermination;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.StatsBase;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class ApdexStatsImpl
implements ApdexStats {
    private static final Integer ZERO = 0;
    private int satisfying;
    private int tolerating;
    private int frustrating;
    private long apdexTInMillis = ZERO.intValue();

    protected ApdexStatsImpl() {
    }

    public ApdexStatsImpl(int s2, int t, int f) {
        this.satisfying = s2;
        this.tolerating = t;
        this.frustrating = f;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ApdexStatsImpl newStats = new ApdexStatsImpl();
        newStats.frustrating = this.frustrating;
        newStats.satisfying = this.satisfying;
        newStats.tolerating = this.tolerating;
        return newStats;
    }

    public String toString() {
        return super.toString() + " [s=" + this.satisfying + ", t=" + this.tolerating + ", f=" + this.frustrating + "]";
    }

    @Override
    public void recordApdexFrustrated() {
        ++this.frustrating;
    }

    @Override
    public int getApdexSatisfying() {
        return this.satisfying;
    }

    @Override
    public int getApdexTolerating() {
        return this.tolerating;
    }

    @Override
    public int getApdexFrustrating() {
        return this.frustrating;
    }

    @Override
    public void recordApdexResponseTime(long responseTimeMillis, long apdexTInMillis) {
        this.apdexTInMillis = apdexTInMillis;
        ApdexPerfZone perfZone = ApdexPerfZoneDetermination.getZone(responseTimeMillis, apdexTInMillis);
        switch (perfZone) {
            case SATISFYING: {
                ++this.satisfying;
                break;
            }
            case TOLERATING: {
                ++this.tolerating;
                break;
            }
            case FRUSTRATING: {
                this.recordApdexFrustrated();
            }
        }
    }

    @Override
    public boolean hasData() {
        return this.satisfying > 0 || this.tolerating > 0 || this.frustrating > 0;
    }

    @Override
    public void reset() {
        this.satisfying = 0;
        this.tolerating = 0;
        this.frustrating = 0;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        double apdexT = Long.valueOf(this.apdexTInMillis).doubleValue() / 1000.0;
        List<Number> data = Arrays.asList(this.satisfying, this.tolerating, this.frustrating, apdexT, apdexT, ZERO);
        JSONArray.writeJSONString(data, writer);
    }

    @Override
    public void merge(StatsBase statsObj) {
        if (statsObj instanceof ApdexStatsImpl) {
            ApdexStatsImpl stats = (ApdexStatsImpl)statsObj;
            this.satisfying += stats.satisfying;
            this.tolerating += stats.tolerating;
            this.frustrating += stats.frustrating;
        }
    }
}

