/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.reinstrument;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.extension.beans.Extension;
import com.newrelic.agent.extension.beans.MethodParameters;
import com.newrelic.agent.extension.util.ExtensionConversionUtility;
import com.newrelic.agent.extension.util.MethodMapper;
import com.newrelic.agent.extension.util.MethodMatcherUtility;
import com.newrelic.agent.instrumentation.custom.ExtensionClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.reinstrument.ReinstrumentResult;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.asm.ClassStructure;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ReinstrumentUtils {
    public static void checkClassExistsAndRetransformClasses(ReinstrumentResult result, List<ExtensionClassAndMethodMatcher> pcs, Extension ext, Set<Class<?>> classesToRetransform) {
        if (!pcs.isEmpty()) {
            HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
            HashMap toRetransform = new HashMap();
            ReinstrumentUtils.getLoadedClassData(pcs, loaders, toRetransform);
            ReinstrumentUtils.checkInputClasses(result, loaders, ext, toRetransform);
        }
        ReinstrumentUtils.retransform(result, classesToRetransform);
    }

    private static void getLoadedClassData(List<ExtensionClassAndMethodMatcher> pcs, Set<ClassLoader> loaders, Map<String, Class<?>> toRetransform) {
        Class[] allLoadedClasses = ServiceFactory.getCoreService().getInstrumentation().getAllLoadedClasses();
        if (allLoadedClasses != null) {
            for (Class current : allLoadedClasses) {
                try {
                    if (current == null) continue;
                    if (current.getClassLoader() != null) {
                        loaders.add(current.getClassLoader());
                    }
                    if (!ReinstrumentUtils.shouldTransform(current, pcs)) continue;
                    toRetransform.put(current.getName(), current);
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINE, "An unexpected exception occurred examining a class for retransformation.");
                    if (!Agent.LOG.isFinestEnabled()) continue;
                    Agent.LOG.log(Level.FINEST, "An exception occurred examining a class for retransformation.", e);
                }
            }
        }
    }

    public static void retransform(ReinstrumentResult result, Set<Class<?>> classesToRetransform) {
        try {
            if (!classesToRetransform.isEmpty()) {
                ServiceFactory.getCoreService().getInstrumentation().retransformClasses(classesToRetransform.toArray(new Class[classesToRetransform.size()]));
                result.setRetranformedInitializedClasses(ReinstrumentUtils.getClassNames(classesToRetransform));
            }
        }
        catch (Exception e) {
            ReinstrumentUtils.handleError(result, MessageFormat.format("Attempt to retransform classes failed. Message: {0}.", e.getMessage()), e);
        }
    }

    private static Set<String> getClassNames(Set<Class<?>> classes) {
        HashSet<String> names = new HashSet<String>();
        for (Class<?> clazz : classes) {
            names.add(clazz.getName());
        }
        return names;
    }

    private static void performRetransformations(ReinstrumentResult result, Map<String, Class<?>> toRetransform) {
        try {
            int size = toRetransform.size();
            if (size > 0) {
                ServiceFactory.getCoreService().getInstrumentation().retransformClasses(toRetransform.values().toArray(new Class[size]));
                result.setRetranformedInitializedClasses(toRetransform.keySet());
            }
        }
        catch (Exception e) {
            ReinstrumentUtils.handleError(result, MessageFormat.format("Attempt to retransform classes failed. Message: {0}.", e.getMessage()), e);
        }
    }

    private static void handleError(ReinstrumentResult result, String msg, Exception e) {
        result.addErrorMessage(msg);
        Agent.LOG.log(Level.INFO, msg);
        if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.log(Level.FINEST, msg, e);
        }
    }

    protected static void handleErrorPartialInstrumentation(ReinstrumentResult result, List<Exception> msgs, String pXml) {
        if (msgs != null && msgs.size() > 0) {
            for (Exception msg : msgs) {
                result.addErrorMessage(msg.getMessage());
                Agent.LOG.log(Level.INFO, msg.getMessage());
            }
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Errors occurred when processing this xml: {0}.", pXml));
            }
        }
    }

    protected static void handleErrorPartialInstrumentation(ReinstrumentResult result, String msg) {
        Agent.LOG.log(Level.INFO, msg);
        result.addErrorMessage(msg);
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.log(Level.FINER, MessageFormat.format("Errors occurred when processing this xml: {0}.", msg));
        }
    }

    protected static void checkInputClasses(ReinstrumentResult result, Set<ClassLoader> loaders, Extension ext, Map<String, Class<?>> toRetransform) {
        if (ext.getInstrumentation() != null) {
            List<Extension.Instrumentation.Pointcut> pcs = ext.getInstrumentation().getPointcut();
            for (Extension.Instrumentation.Pointcut pointcut : pcs) {
                if (pointcut.getMethodAnnotation() != null) continue;
                ReinstrumentUtils.checkForClassAndMethods(result, loaders, ExtensionConversionUtility.getClassName(pointcut), toRetransform, pointcut);
            }
        }
    }

    private static void checkForClassAndMethods(ReinstrumentResult result, Set<ClassLoader> loaders, String className, Map<String, Class<?>> toRetransform, Extension.Instrumentation.Pointcut pc) {
        if (className != null) {
            Class<?> current = toRetransform.get(className);
            if (current != null) {
                ReinstrumentUtils.checkMethodsInClass(result, ClassStructure.getClassStructure(current), pc);
            } else {
                for (ClassLoader loader : loaders) {
                    URL resource;
                    if (loader == null || (resource = loader.getResource(className.replace(".", "/") + ".class")) == null) continue;
                    try {
                        ReinstrumentUtils.checkMethodsInClass(result, ClassStructure.getClassStructure(resource), pc);
                        return;
                    }
                    catch (IOException e) {
                        Agent.LOG.log(Level.FINER, "Error validating class " + className, e);
                    }
                }
                ReinstrumentUtils.handleErrorPartialInstrumentation(result, MessageFormat.format("The class {0} does not match a loaded class in the JVM. Either the class has not been loaded yet or it does not exist.", className));
            }
        }
    }

    private static void checkMethodsInClass(ReinstrumentResult result, ClassStructure classStructure, Extension.Instrumentation.Pointcut pc) {
        List<Extension.Instrumentation.Pointcut.Method> desiredMethods = pc.getMethod();
        if (desiredMethods != null) {
            Set<Method> actualMethods = classStructure.getMethods();
            for (Extension.Instrumentation.Pointcut.Method m3 : desiredMethods) {
                if (ReinstrumentUtils.foundMethod(m3, actualMethods)) continue;
                ReinstrumentUtils.handleErrorPartialInstrumentation(result, MessageFormat.format("The method {0} with parameter type {1} on class {2} is not present and therefore will never match anything.", m3.getName(), MethodParameters.getDescriptor(m3.getParameters()), ExtensionConversionUtility.getClassName(pc)));
            }
        }
    }

    private static boolean foundMethod(Extension.Instrumentation.Pointcut.Method method, Set<Method> actualMethods) {
        try {
            MethodMatcher methodMatcher = MethodMatcherUtility.createMethodMatcher("BogusClass", method, new HashMap<String, MethodMapper>(), "");
            for (Method m3 : actualMethods) {
                if (!methodMatcher.matches(-1, m3.getName(), m3.getDescriptor(), MethodMatcher.UNSPECIFIED_ANNOTATIONS)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            Agent.LOG.log(Level.FINEST, ex.getMessage());
        }
        return false;
    }

    private static boolean shouldTransform(Class<?> clazz, List<ExtensionClassAndMethodMatcher> newPcs) {
        for (ExtensionClassAndMethodMatcher pc : newPcs) {
            if (!pc.getClassMatcher().isMatch(clazz)) continue;
            return true;
        }
        return false;
    }
}

