/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.CacheLoader;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.profile.method.MethodInfoFactory;
import com.newrelic.agent.profile.v2.IProfile;
import com.newrelic.agent.profile.v2.Murmur3StringMap;
import com.newrelic.agent.profile.v2.ProfileSegment;
import com.newrelic.agent.profile.v2.ProfileTree;
import com.newrelic.agent.profile.v2.ProfiledMethodFactory;
import com.newrelic.agent.profile.v2.TransactionProfileSession;
import com.newrelic.agent.profile.v2.TransactionProfileSessionImpl;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.threads.BasicThreadInfo;
import com.newrelic.agent.threads.ThreadNameNormalizer;
import com.newrelic.agent.transport.DataSenderWriter;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.agent.util.StringMap;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class Profile
implements IProfile {
    public static final int MAX_STACK_DEPTH = 300;
    public static final int MAX_STACK_SIZE = 60000;
    public static final int MAX_ENCODED_BYTES = 1000000;
    public static final int MAX_ENCODED_DATA_BYTES = 999856;
    public static final int STACK_TRIM = 10000;
    private static final int JSON_VERSION = 2;
    private long startTimeMillis = 0L;
    private long endTimeMillis = 0L;
    private int sampleCount = 0;
    private int totalThreadCount = 0;
    private int runnableThreadCount = 0;
    private final ThreadMXBean threadMXBean;
    private final LoadingCache<Long, Long> startThreadCpuTimes = Caffeine.newBuilder().build(new CacheLoader<Long, Long>(){

        @Override
        public Long load(Long threadId) throws Exception {
            return Profile.this.threadMXBean.getThreadCpuTime(threadId);
        }
    });
    private final ProfilerParameters profilerParameters;
    private final Map<Long, ProfileTree> threadIdToProfileTrees = new HashMap<Long, ProfileTree>();
    private final LoadingCache<String, ProfileTree> profileTrees = Caffeine.newBuilder().build(this.createCacheLoader(true));
    private final StringMap stringMap = new Murmur3StringMap();
    private final ProfiledMethodFactory profiledMethodFactory;
    private final ThreadNameNormalizer threadNameNormalizer;
    private final TransactionProfileSession transactionProfileSession;
    private final String sessionId;

    public Profile(ProfilerParameters parameters, String sessionId, ThreadNameNormalizer threadNameNormalizer) {
        this(parameters, sessionId, threadNameNormalizer, ManagementFactory.getThreadMXBean());
    }

    Profile(ProfilerParameters parameters, String sessionId, ThreadNameNormalizer threadNameNormalizer, ThreadMXBean threadMXBean) {
        this.profilerParameters = parameters;
        this.sessionId = sessionId;
        this.threadNameNormalizer = threadNameNormalizer;
        this.profiledMethodFactory = new ProfiledMethodFactory(this);
        this.transactionProfileSession = parameters.isProfileInstrumentation() ? new TransactionProfileSessionImpl(this, threadNameNormalizer) : TransactionProfileSessionImpl.NO_OP_TRANSACTION_PROFILE_SESSION;
        this.threadMXBean = threadMXBean;
    }

    CacheLoader<String, ProfileTree> createCacheLoader(final boolean reportCpu) {
        return new CacheLoader<String, ProfileTree>(){

            @Override
            public ProfileTree load(String key) throws Exception {
                return new ProfileTree(Profile.this, reportCpu);
            }
        };
    }

    private Map<Long, Long> getThreadCpuTimes() {
        if (!this.threadMXBean.isThreadCpuTimeSupported() || !this.threadMXBean.isThreadCpuTimeEnabled()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> cpuTimes = new HashMap<Long, Long>();
        for (long id : this.threadMXBean.getAllThreadIds()) {
            cpuTimes.put(id, this.threadMXBean.getThreadCpuTime(id));
        }
        return cpuTimes;
    }

    @Override
    public ProfileTree getProfileTree(String normalizedThreadName) {
        return this.profileTrees.get(normalizedThreadName);
    }

    @Override
    public void start() {
        this.startTimeMillis = System.currentTimeMillis();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            Agent.LOG.info("Profile unable to record CPU time: Thread CPU time measurement is not supported");
        } else if (!threadMXBean.isThreadCpuTimeEnabled()) {
            Agent.LOG.info("Profile unable to record CPU time: Thread CPU time measurement is not enabled");
        } else {
            this.startThreadCpuTimes.asMap().putAll(this.getThreadCpuTimes());
        }
    }

    @Override
    public void end() {
        this.endTimeMillis = System.currentTimeMillis();
        Map<Long, Long> endThreadCpuTimes = this.getThreadCpuTimes();
        for (Map.Entry<Long, Long> entry : endThreadCpuTimes.entrySet()) {
            Long startTime = this.startThreadCpuTimes.get(entry.getKey());
            if (startTime == null) {
                startTime = 0L;
            }
            long cpuTime = TimeUnit.MILLISECONDS.convert(entry.getValue() - startTime, TimeUnit.NANOSECONDS);
            ProfileTree tree = this.threadIdToProfileTrees.get(entry.getKey());
            if (null == tree) continue;
            tree.incrementCpuTime(cpuTime);
        }
        int stackCount = this.getCallSiteCount();
        String msg = MessageFormat.format("Profile size is {0} stack elements", stackCount);
        Agent.LOG.info(msg);
        if (stackCount > 60000) {
            Agent.LOG.info(MessageFormat.format("Trimmed profile size by {0} stack elements", this.trim(stackCount - 60000, stackCount)));
        }
    }

    @Override
    public Set<Long> getThreadIds() {
        return this.threadIdToProfileTrees.keySet();
    }

    @Override
    public void markInstrumentedMethods() {
        try {
            this.doMarkInstrumentedMethods();
        }
        catch (Throwable ex) {
            String msg = MessageFormat.format("Error marking instrumented methods {0}", ex);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, ex);
            }
            Agent.LOG.finer(msg);
        }
    }

    private void doMarkInstrumentedMethods() {
        MethodInfoFactory methodInfoFactory = new MethodInfoFactory();
        this.profiledMethodFactory.setMethodDetails(methodInfoFactory);
    }

    @Override
    public int trimBy(int limit) {
        return this.trim(limit, this.getCallSiteCount());
    }

    private int trim(int limit, int stackCount) {
        ProfileSegmentSort[] segments = this.getSortedSegments(stackCount);
        int count = 0;
        for (ProfileSegmentSort segment : segments) {
            if (count >= limit) break;
            segment.remove();
            ++count;
        }
        return count;
    }

    private ProfileSegmentSort[] getSortedSegments(int stackCount) {
        Object[] segments = new ProfileSegmentSort[stackCount];
        int index = 0;
        for (ProfileTree profileTree : this.profileTrees.asMap().values()) {
            for (ProfileSegment rootSegment : profileTree.getRootSegments()) {
                index = this.addSegment(rootSegment, null, 1, (ProfileSegmentSort[])segments, index);
            }
        }
        Arrays.sort(segments);
        return segments;
    }

    private int addSegment(ProfileSegment segment, ProfileSegment parent, int depth, ProfileSegmentSort[] segments, int index) {
        ProfileSegmentSort segSort = new ProfileSegmentSort(segment, parent, depth);
        segments[index++] = segSort;
        for (ProfileSegment child : segment.getChildren()) {
            index = this.addSegment(child, segment, ++depth, segments, index);
        }
        return index;
    }

    private int getCallSiteCount() {
        int count = 0;
        for (ProfileTree profileTree : this.profileTrees.asMap().values()) {
            count += profileTree.getCallSiteCount();
        }
        return count;
    }

    @Override
    public StringMap getStringMap() {
        return this.stringMap;
    }

    @Override
    public ProfiledMethodFactory getProfiledMethodFactory() {
        return this.profiledMethodFactory;
    }

    @Override
    public Long getProfileId() {
        return this.profilerParameters.getProfileId();
    }

    @Override
    public ProfilerParameters getProfilerParameters() {
        return this.profilerParameters;
    }

    @Override
    public void beforeSampling() {
        ++this.sampleCount;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public final long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Override
    public final long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        Object xraySessionId = null;
        JSONArray.writeJSONString(Arrays.asList(this.profilerParameters.getProfileId(), this.startTimeMillis, this.endTimeMillis, this.sampleCount, this.getData(out), this.totalThreadCount, this.runnableThreadCount, xraySessionId, this.sessionId, Integer.toString(2)), out);
    }

    private Map<String, Object> getJsonMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("profile_arguments", this.profilerParameters);
        data.put("version", 2);
        data.put("threads", this.profileTrees.asMap());
        data.put("instrumentation", this.transactionProfileSession);
        data.put("agent_thread_names", this.getAgentThreadNames());
        data.put("methods", this.profiledMethodFactory.getMethods());
        data.put("classes", this.profiledMethodFactory.getClasses());
        data.put("string_map", this.stringMap.getStringMap());
        return data;
    }

    private Object getData(Writer out) {
        Map<String, Object> data = this.getJsonMap();
        Object result = DataSenderWriter.getJsonifiedOptionallyCompressedEncodedString(data, out, 1, 999856);
        int maxStack = 60000;
        while (result == null && maxStack > 0) {
            int stackCount = this.getCallSiteCount();
            this.trim(stackCount - (maxStack -= 10000), stackCount);
            result = DataSenderWriter.getJsonifiedOptionallyCompressedEncodedString(data, out, 1, 999856);
        }
        if (result != null && DataSenderWriter.isCompressingWriter(out)) {
            String msg = MessageFormat.format("Profile v2 serialized size = {0} bytes", result.toString().length());
            Agent.LOG.info(msg);
        }
        return result;
    }

    private Collection<Object> getAgentThreadNames() {
        Set<Long> agentThreadIds = ServiceFactory.getThreadService().getAgentThreadIds();
        HashSet<Object> names = new HashSet<Object>();
        for (long id : agentThreadIds) {
            ThreadInfo threadInfo = this.threadMXBean.getThreadInfo(id, 0);
            names.add(this.stringMap.addString(this.threadNameNormalizer.getNormalizedThreadName(new BasicThreadInfo(threadInfo))));
        }
        return new ArrayList<Object>(names);
    }

    private void incrementThreadCounts(boolean runnable2) {
        ++this.totalThreadCount;
        if (runnable2) {
            ++this.runnableThreadCount;
        }
    }

    private boolean shouldScrubStack(ThreadType type) {
        if (ThreadType.BasicThreadType.AGENT.equals(type)) {
            return false;
        }
        return !this.profilerParameters.isProfileAgentThreads();
    }

    @Override
    public void addStackTrace(ThreadInfo threadInfo, boolean runnable2, ThreadType type) {
        this.addStackTrace(new BasicThreadInfo(threadInfo), threadInfo.getStackTrace(), runnable2, type);
    }

    void addStackTrace(BasicThreadInfo threadInfo, StackTraceElement[] stackTrace, boolean runnable2, ThreadType type) {
        if (stackTrace.length < 2) {
            return;
        }
        this.startThreadCpuTimes.get(threadInfo.getId());
        this.incrementThreadCounts(runnable2);
        List<StackTraceElement> stackTraceList = this.shouldScrubStack(type) ? StackTraces.scrubAndTruncate(Arrays.asList(stackTrace), 0) : Arrays.asList(stackTrace);
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>(stackTraceList);
        Collections.reverse(result);
        String normalizedThreadName = this.threadNameNormalizer.getNormalizedThreadName(threadInfo);
        ProfileTree profileTree = this.getProfileTree(normalizedThreadName);
        this.threadIdToProfileTrees.put(threadInfo.getId(), profileTree);
        profileTree.addStackTrace(result, runnable2);
    }

    @Override
    public TransactionProfileSession getTransactionProfileSession() {
        return this.transactionProfileSession;
    }

    private static class ProfileSegmentSort
    implements Comparable<ProfileSegmentSort> {
        private final ProfileSegment segment;
        private final ProfileSegment parent;
        private final int depth;

        private ProfileSegmentSort(ProfileSegment segment, ProfileSegment parent, int depth) {
            this.segment = segment;
            this.parent = parent;
            this.depth = depth;
        }

        void remove() {
            if (this.parent != null) {
                this.parent.removeChild(this.segment.getMethod());
            }
        }

        public String toString() {
            return this.segment.toString();
        }

        @Override
        public int compareTo(ProfileSegmentSort other) {
            int otherCount;
            int thisCount = this.segment.getRunnableCallCount();
            if (thisCount == (otherCount = other.segment.getRunnableCallCount())) {
                return this.depth > other.depth ? -1 : (this.depth == other.depth ? 0 : 1);
            }
            return thisCount > otherCount ? 1 : -1;
        }
    }
}

