/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver.extension;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.ExtensionHolder;
import com.newrelic.agent.bridge.ExtensionHolderFactory;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Cache;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Supplier;
import java.util.logging.Level;

public class ExtensionHolderFactoryImpl
implements ExtensionHolderFactory {
    public <T> ExtensionHolder<T> build() {
        return new ExtensionHolderImpl();
    }

    public static class ExtensionHolderImpl<T>
    implements ExtensionHolder<T> {
        private final Cache<Object, T> instanceCache = Caffeine.newBuilder().initialCapacity(32).weakKeys().build();

        public T getAndRemoveExtension(Object instance) {
            return (T)this.instanceCache.asMap().remove(instance);
        }

        public T getExtension(Object instance, Supplier<T> valueLoader) {
            try {
                return (T)this.instanceCache.get(instance, k -> valueLoader.get());
            }
            catch (RuntimeException e) {
                AgentBridge.getAgent().getLogger().log(Level.FINE, (Throwable)e, "Unable to load extension class for {0}", (Object)instance.getClass().getName());
                throw e;
            }
        }
    }
}

