/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.MetricNames;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.CustomRequestHeaderConfig;
import com.newrelic.agent.config.CustomRequestHeaderConfigImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class TransactionEventsConfig
extends BaseConfig {
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.transaction_events.";
    public static final String MAX_SAMPLES_STORED = "max_samples_stored";
    public static final String CUSTOM_REQUEST_HEADERS = "custom_request_headers";
    private static final String COLLECT_ANALYTICS_EVENTS = "collect_analytics_events";
    private static final String ENABLED = "enabled";
    private static final String TARGET_SAMPLES_STORED = "target_samples_stored";
    public static final String REQUEST_HEADER_NAME = "header_name";
    public static final String HEADER_ALIAS = "header_alias";
    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_MAX_SAMPLES_STORED = 2000;
    public static final int DEFAULT_TARGET_SAMPLES_STORED = 10;
    private final boolean enabled;
    private final int maxSamplesStored = this.getProperty("max_samples_stored", 2000);
    private final int targetSamplesStored;
    private final Set<CustomRequestHeaderConfig> requestHeaderConfigs;

    public TransactionEventsConfig(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.enabled = this.maxSamplesStored > 0 & this.initEnabled();
        this.targetSamplesStored = this.getProperty(TARGET_SAMPLES_STORED, 10);
        this.requestHeaderConfigs = this.initCustomRequestHeaders();
    }

    private boolean initEnabled() {
        return this.getProperty(ENABLED, true) != false && this.getProperty(COLLECT_ANALYTICS_EVENTS, true) != false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    public Set<CustomRequestHeaderConfig> getRequestHeaderConfigs() {
        return this.requestHeaderConfigs;
    }

    public int getTargetSamplesStored() {
        return this.targetSamplesStored;
    }

    public Set<CustomRequestHeaderConfig> initCustomRequestHeaders() {
        HashSet<CustomRequestHeaderConfig> headerConfigs = new HashSet<CustomRequestHeaderConfig>();
        Object customRequestHeader = this.getProperty(CUSTOM_REQUEST_HEADERS);
        if (customRequestHeader instanceof Collection) {
            for (Object header : (Collection)customRequestHeader) {
                if (header instanceof Map) {
                    Map customRequestHeaderMap = (Map)header;
                    String name = (String)customRequestHeaderMap.get(REQUEST_HEADER_NAME);
                    String alias = (String)customRequestHeaderMap.get(HEADER_ALIAS);
                    if (name != null) {
                        if (alias != null && !alias.isEmpty()) {
                            MetricNames.recordApiSupportabilityMetric("CustomRequestHeader/Config/Alias");
                        } else {
                            MetricNames.recordApiSupportabilityMetric("CustomRequestHeader/Config/RequestHeader");
                        }
                        headerConfigs.add(new CustomRequestHeaderConfigImpl(name, alias));
                        continue;
                    }
                    AgentBridge.getAgent().getLogger().log(Level.WARNING, "Invalid customer_request_header config encountered. header_name must not be null. This configuration will be ignored");
                    continue;
                }
                if (!(header instanceof String)) continue;
                String name = (String)header;
                headerConfigs.add(new CustomRequestHeaderConfigImpl(name, null));
                MetricNames.recordApiSupportabilityMetric("CustomRequestHeader/Config/RequestHeader");
            }
        }
        return headerConfigs;
    }

    public static TransactionEventsConfig createTransactionEventConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new TransactionEventsConfig(settings);
    }
}

