/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.service.EventService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.SpanEventsServiceImpl;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.StatsWorks;
import java.util.concurrent.TimeUnit;

public abstract class Harvestable {
    private final EventService service;
    private final String appName;
    private volatile long lastHarvest;

    public Harvestable(EventService service, String appName) {
        this.service = service;
        this.appName = appName;
        this.lastHarvest = System.nanoTime();
    }

    public abstract String getEndpointMethodName();

    public abstract int getMaxSamplesStored();

    public void harvest() {
        this.recordIntervalMetric();
        this.service.harvestEvents(this.appName);
    }

    private void recordIntervalMetric() {
        long startTimeInNanos = System.nanoTime();
        final long harvestIntervalInNanos = startTimeInNanos - this.lastHarvest;
        this.lastHarvest = startTimeInNanos;
        ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

            @Override
            public void doWork(StatsEngine statsEngine) {
                if (harvestIntervalInNanos > 0L) {
                    statsEngine.getResponseTimeStats(Harvestable.this.service.getEventHarvestIntervalMetric()).recordResponseTime(harvestIntervalInNanos, TimeUnit.NANOSECONDS);
                }
            }

            @Override
            public String getAppName() {
                return Harvestable.this.appName;
            }
        });
    }

    public String getAppName() {
        return this.appName;
    }

    public void configure(long reportPeriodInMillis, int maxSamplesStored) {
        long reportPeriodInSeconds = TimeUnit.MILLISECONDS.toSeconds(reportPeriodInMillis);
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork(this.service.getReportPeriodInSecondsMetric(), reportPeriodInSeconds));
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork(this.service.getEventHarvestLimitMetric(), maxSamplesStored));
        if (maxSamplesStored != this.service.getMaxSamplesStored()) {
            this.service.setMaxSamplesStored(maxSamplesStored);
            this.maybeSendSpanLimitMetric(maxSamplesStored);
            this.service.harvestEvents(this.appName);
            this.service.clearReservoir();
        }
    }

    private void maybeSendSpanLimitMetric(int maxSamplesStored) {
        if (this.service instanceof SpanEventsServiceImpl) {
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/SpanEvent/Limit", maxSamplesStored));
        }
    }
}

