/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.weave.utils.BootstrapLoader;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.ClassLoaderFinder;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.weavepackage.ClassWeavedListener;
import com.newrelic.weave.weavepackage.NewClassAppender;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.PackageWeaveResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageLifetimeListener;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class WeavePackageManager {
    private final ConcurrentMap<String, WeavePackage> weavePackages = new ConcurrentHashMap<String, WeavePackage>();
    private final Set<String> requiredClasses = Sets.newConcurrentHashSet();
    private final Set<String> methodSignatures = Sets.newConcurrentHashSet();
    private final Set<String> requiredAnnotationClasses = Sets.newConcurrentHashSet();
    private final Set<String> requiredMethodAnnotationClasses = Sets.newConcurrentHashSet();
    private final Cache<ClassLoader, ConcurrentMap<String, WeavePackage>> optimizedWeavePackages = CacheBuilder.newBuilder().weakKeys().build();
    private final WeavePackageLifetimeListener packageListener;
    private final Instrumentation instrumentation;
    private final int maxPreValidatedClassLoaders;
    private final boolean preValidateWeavePackages;
    private final boolean preMatchWeaveMethods;
    private static final ThreadLocal<PackageValidationResult> currentValidationResult = new ThreadLocal();
    static final int MAX_VALID_PACKAGE_CACHE = 100;
    static final int MAX_INVALID_PACKAGE_CACHE = 100;
    Cache<ClassLoader, ConcurrentMap<WeavePackage, PackageValidationResult>> validPackages = CacheBuilder.newBuilder().weakKeys().concurrencyLevel(8).maximumSize(100L).build();
    Cache<ClassLoader, ConcurrentMap<WeavePackage, PackageValidationResult>> invalidPackages = CacheBuilder.newBuilder().weakKeys().concurrencyLevel(8).maximumSize(100L).build();

    WeavePackageManager() {
        this(null);
    }

    public WeavePackageManager(WeavePackageLifetimeListener listener) {
        this(listener, null, 10, true, true);
    }

    public WeavePackageManager(WeavePackageLifetimeListener listener, Instrumentation instrumentation, int maxPreValidatedClassLoaders, boolean preValidateWeavePackages, boolean preMatchWeaveMethods) {
        this.packageListener = listener;
        this.instrumentation = instrumentation;
        this.maxPreValidatedClassLoaders = maxPreValidatedClassLoaders;
        this.preValidateWeavePackages = preValidateWeavePackages;
        this.preMatchWeaveMethods = preMatchWeaveMethods;
    }

    boolean canWeaveBootstrapClassLoader() {
        return null != this.instrumentation;
    }

    public boolean isRegistered(String weavePackageName) {
        return this.weavePackages.containsKey(weavePackageName);
    }

    public void register(WeavePackage weavePackage) {
        if (null != weavePackage && !this.weavePackages.containsKey(weavePackage.getName()) && this.weavePackages.putIfAbsent(weavePackage.getName(), weavePackage) == null) {
            this.methodSignatures.addAll(weavePackage.getMethodSignatures());
            this.requiredClasses.addAll(weavePackage.getRequiredClasses());
            this.requiredAnnotationClasses.addAll(weavePackage.getAllRequiredAnnotationClasses());
            this.requiredMethodAnnotationClasses.addAll(weavePackage.getAllRequiredMethodAnnotationClasses());
            if (null != this.packageListener) {
                this.packageListener.registered(weavePackage);
            }
            this.optimizedWeavePackages.invalidateAll();
        }
    }

    public WeavePackage deregister(WeavePackage weavePackage) {
        if (null == weavePackage) {
            return null;
        }
        WeavePackage remove = (WeavePackage)this.weavePackages.remove(weavePackage.getName());
        if (null != remove) {
            this.optimizedWeavePackages.invalidateAll();
            this.requiredClasses.removeAll(remove.getRequiredClasses());
            this.rebuildWeavePackages();
        }
        if (null != remove && null != this.packageListener) {
            this.packageListener.deregistered(remove);
        }
        return remove;
    }

    private void rebuildWeavePackages() {
        Set<String> updatedMethodSignatures = Sets.newConcurrentHashSet();
        for (WeavePackage weavePackage : this.weavePackages.values()) {
            updatedMethodSignatures.addAll(weavePackage.getMethodSignatures());
        }
        this.methodSignatures.clear();
        this.methodSignatures.addAll(updatedMethodSignatures);
    }

    public WeavePackage deregister(String weavePackageName) {
        return this.deregister((WeavePackage)this.weavePackages.get(weavePackageName));
    }

    public WeavePackage getWeavePackage(String name) {
        return (WeavePackage)this.weavePackages.get(name);
    }

    public Collection<WeavePackage> getRegisteredPackages() {
        return this.weavePackages.values();
    }

    private ClassLoader classLoaderSub(ClassLoader classloader) {
        if (null == classloader) {
            return BootstrapLoader.PLACEHOLDER;
        }
        return classloader;
    }

    public Set<PackageValidationResult> match(ClassLoader classloader, String className, ClassCache cache) throws IOException {
        classloader = this.classLoaderSub(classloader);
        ClassInformation classInformation = cache.getClassInformation(className);
        if (null == classInformation) {
            return Collections.emptySet();
        }
        String[] superNames = classInformation.getAllSuperNames(cache).toArray(new String[0]);
        String[] interfaceNames = classInformation.getAllInterfaces(cache).toArray(new String[0]);
        Set<String> classAnnotations = classInformation.classAnnotationNames;
        Set<String> methodAnnotations = classInformation.methodAnnotationNames;
        return this.match(classloader, cache, className, classAnnotations, methodAnnotations, superNames, interfaceNames);
    }

    private Set<PackageValidationResult> match(ClassLoader classloader, ClassCache cache, String className, Set<String> classAnnotations, Set<String> methodAnnotations, String[] superNames, String[] interfaceNames) throws IOException {
        Set<PackageValidationResult> matchedPackageResults = Sets.newConcurrentHashSet();
        Map<String, WeavePackage> classloaderWeavePackages = this.preValidateWeavePackages && this.optimizedWeavePackages.size() < (long)this.maxPreValidatedClassLoaders ? this.getOptimizedWeavePackages(classloader, cache) : this.weavePackages;
        for (WeavePackage weavePackage : classloaderWeavePackages.values()) {
            PackageValidationResult successfulValidation;
            if (!weavePackage.hasMatcher(className, superNames, interfaceNames, classAnnotations, methodAnnotations, cache) || null == (successfulValidation = this.getSuccessfulValidation(className, superNames[0], interfaceNames, classloader, cache, weavePackage))) continue;
            matchedPackageResults.add(successfulValidation);
        }
        return matchedPackageResults;
    }

    public byte[] weave(ClassLoader classloader, String className, byte[] targetBytes) throws IOException {
        classloader = this.classLoaderSub(classloader);
        ClassCache cache = new ClassCache(new ClassLoaderFinder(classloader));
        return this.weave(classloader, cache, className, targetBytes, null);
    }

    public byte[] weave(ClassLoader classloader, ClassCache cache, String className, byte[] targetBytes, ClassWeavedListener weaveListener) throws IOException {
        String[] interfaceNames;
        classloader = this.classLoaderSub(classloader);
        if (this.preMatchWeaveMethods && !this.containsPossibleClassOrMethodMatch(className, targetBytes, this.requiredClasses, this.methodSignatures, cache)) {
            return null;
        }
        ClassInformation classInformation = cache.getClassInformation(className);
        if (classInformation == null) {
            return null;
        }
        Set<String> classAnnotations = cache.getClassInformation((String)className).classAnnotationNames;
        Set<String> methodAnnotations = cache.getClassInformation((String)className).methodAnnotationNames;
        String[] superNames = cache.getClassInformation(className).getAllSuperNames(cache).toArray(new String[0]);
        Set<PackageValidationResult> matchedPackageResults = this.match(classloader, cache, className, classAnnotations, methodAnnotations, superNames, interfaceNames = cache.getClassInformation(className).getAllInterfaces(cache).toArray(new String[0]));
        if (matchedPackageResults.isEmpty()) {
            return null;
        }
        ClassNode composite = WeaveUtils.convertToClassNode(targetBytes);
        PackageWeaveResult finalResult = null;
        for (PackageValidationResult weavePackageResult : matchedPackageResults) {
            PackageWeaveResult result = weavePackageResult.weave(className, superNames, interfaceNames, composite, cache);
            if (null != weaveListener) {
                weaveListener.classWeaved(result, classloader, cache);
            }
            if (!result.weavedClass()) continue;
            composite = result.getComposite();
            finalResult = result;
        }
        return null == finalResult ? null : finalResult.getCompositeBytes(cache);
    }

    private boolean containsPossibleClassOrMethodMatch(final String className, byte[] classBytes, final Set<String> requiredClasses, final Set<String> methodSignatures, final ClassCache cache) {
        final AtomicBoolean containsPossibleMatch = new AtomicBoolean(false);
        ClassReader originalBytesReader = new ClassReader(classBytes);
        originalBytesReader.accept(new ClassVisitor(458752){
            public String[] interfaces;
            private boolean isInterface;
            {
                super(x0);
                this.isInterface = false;
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.interfaces = interfaces;
                boolean bl = this.isInterface = (access & 0x200) == 512;
                if (requiredClasses.contains(name) || requiredClasses.contains(superName)) {
                    containsPossibleMatch.set(true);
                    return;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                String annotationClass = Type.getType(desc).getClassName();
                if (!this.isInterface && WeavePackageManager.this.requiredAnnotationClasses.contains(annotationClass)) {
                    containsPossibleMatch.set(true);
                    requiredClasses.add(className);
                    return null;
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (containsPossibleMatch.get()) {
                    return null;
                }
                if (!(name.equals("<init>") && desc.equals("()V") || name.equals("<clinit>") && desc.equals("()V") || !methodSignatures.contains(name + desc))) {
                    containsPossibleMatch.set(true);
                    return null;
                }
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (!WeavePackageManager.this.requiredMethodAnnotationClasses.isEmpty()) {
                    return new MethodVisitor(458752, mv){

                        @Override
                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            String annotationClass = Type.getType(desc).getClassName();
                            if (WeavePackageManager.this.requiredMethodAnnotationClasses.contains(annotationClass)) {
                                containsPossibleMatch.set(true);
                                return null;
                            }
                            return super.visitAnnotation(desc, visible);
                        }
                    };
                }
                return mv;
            }

            @Override
            public void visitEnd() {
                if (!this.isInterface && !WeavePackageManager.this.requiredAnnotationClasses.isEmpty()) {
                    try {
                        for (String interfaceName : this.interfaces) {
                            ClassInformation interfaceInfo = cache.getClassInformation(interfaceName);
                            if (interfaceInfo == null) continue;
                            for (String interfaceAnnotationName : interfaceInfo.classAnnotationNames) {
                                if (!WeavePackageManager.this.requiredAnnotationClasses.contains(WeaveUtils.getClassBinaryName(interfaceAnnotationName))) continue;
                                containsPossibleMatch.set(true);
                                return;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }, 7);
        return containsPossibleMatch.get();
    }

    private PackageValidationResult getSuccessfulValidation(String className, String superName, String[] interfaceNames, ClassLoader classloader, ClassCache cache, WeavePackage weavePackage) throws IOException {
        PackageValidationResult localValidationResult = currentValidationResult.get();
        if (localValidationResult != null) {
            return localValidationResult;
        }
        if (this.validateAgainstClassLoader(className, superName, interfaceNames, classloader, cache, weavePackage)) {
            ClassLoader classloaderToUse = weavePackage.weavesBootstrap() ? BootstrapLoader.PLACEHOLDER : classloader;
            ConcurrentMap<WeavePackage, PackageValidationResult> valid = this.validPackages.getIfPresent(classloaderToUse);
            return valid == null ? null : (PackageValidationResult)valid.get(weavePackage);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateAgainstClassLoader(String className, String superName, String[] interfaceNames, ClassLoader classloader, ClassCache cache, WeavePackage weavePackage) throws IOException {
        if (classloader != BootstrapLoader.PLACEHOLDER && weavePackage.weavesBootstrap()) {
            classloader = BootstrapLoader.PLACEHOLDER;
            cache = new ClassCache(BootstrapLoader.get());
        }
        try {
            ConcurrentMap<WeavePackage, PackageValidationResult> result;
            if (!this.hasValidated(classloader, weavePackage)) {
                PackageValidationResult verificationResult = weavePackage.validate(cache);
                currentValidationResult.set(verificationResult);
                if (null != this.packageListener) {
                    this.packageListener.validated(verificationResult, classloader);
                }
                if (classloader == BootstrapLoader.PLACEHOLDER && !this.canWeaveBootstrapClassLoader() || !verificationResult.succeeded()) {
                    ConcurrentMap result2 = this.invalidPackages.asMap().putIfAbsent(classloader, new ConcurrentHashMap());
                    if (result2 == null) {
                        result2 = (ConcurrentMap)this.invalidPackages.asMap().get(classloader);
                    }
                    result2.put(weavePackage, verificationResult);
                    boolean bl = false;
                    return bl;
                }
                ConcurrentMap result3 = this.validPackages.asMap().putIfAbsent(classloader, new ConcurrentHashMap());
                if (result3 == null) {
                    result3 = (ConcurrentMap)this.validPackages.asMap().get(classloader);
                }
                try {
                    if (BootstrapLoader.PLACEHOLDER == classloader) {
                        NewClassAppender.appendClassesToBootstrapClassLoader(this.instrumentation, verificationResult.computeUtilityClassBytes(cache));
                    } else {
                        NewClassAppender.appendClasses(className, superName, interfaceNames, classloader, verificationResult.computeUtilityClassBytes(cache));
                    }
                    result3.put(weavePackage, verificationResult);
                }
                catch (Throwable t) {
                    result3.remove(weavePackage);
                }
            }
            boolean bl = (result = this.validPackages.getIfPresent(classloader)) != null && result.containsKey(weavePackage);
            return bl;
        }
        finally {
            currentValidationResult.remove();
        }
    }

    private boolean hasValidated(ClassLoader classloader, WeavePackage weavePackage) {
        ConcurrentMap<WeavePackage, PackageValidationResult> invalidResult = this.invalidPackages.getIfPresent(classloader);
        ConcurrentMap<WeavePackage, PackageValidationResult> validResult = this.validPackages.getIfPresent(classloader);
        return invalidResult != null && invalidResult.containsKey(weavePackage) || validResult != null && validResult.containsKey(weavePackage);
    }

    private Map<String, WeavePackage> getOptimizedWeavePackages(ClassLoader classloader, ClassCache cache) {
        ConcurrentMap<String, WeavePackage> classloaderWeavePackages = this.optimizedWeavePackages.getIfPresent(classloader);
        if (classloaderWeavePackages == null) {
            classloaderWeavePackages = new ConcurrentHashMap<String, WeavePackage>();
            ArrayList unmatchedWeavePackages = new ArrayList();
            for (Map.Entry entry : this.weavePackages.entrySet()) {
                boolean packageExists = true;
                boolean hasAtLeastOneMatch = false;
                for (String weaveClass : ((WeavePackage)entry.getValue()).getRequiredClasses()) {
                    if (!cache.hasClassResource(weaveClass)) {
                        packageExists = false;
                        continue;
                    }
                    hasAtLeastOneMatch = true;
                    if (packageExists) continue;
                    break;
                }
                if (packageExists) {
                    classloaderWeavePackages.put((String)entry.getKey(), (WeavePackage)entry.getValue());
                    continue;
                }
                if (!hasAtLeastOneMatch) continue;
                unmatchedWeavePackages.add(entry.getValue());
            }
            ConcurrentMap<String, WeavePackage> optimizedMap = this.optimizedWeavePackages.asMap().putIfAbsent(classloader, classloaderWeavePackages);
            if (optimizedMap == null) {
                for (WeavePackage unmatchedWeavePackage : unmatchedWeavePackages) {
                    try {
                        PackageValidationResult verificationResult = unmatchedWeavePackage.validate(cache);
                        if (null == this.packageListener) continue;
                        this.packageListener.validated(verificationResult, classloader);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return classloaderWeavePackages;
    }
}

