/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util.asm;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.reflect.ClassReflection;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.util.asm.AnnotationDetails;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.weave.utils.SynchronizedFieldNode;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ClassStructure {
    public static final int METHODS = 1;
    public static final int FIELDS = 2;
    public static final int CLASS_ANNOTATIONS = 4;
    public static final int METHOD_ANNOTATIONS = 8;
    public static final int ALL = 15;
    private Map<Method, MethodDetails> methods;
    private Map<String, FieldNode> fields;
    private final Type type;
    protected final int access;
    protected final String superName;
    protected final String[] interfaces;
    protected Map<String, AnnotationDetails> classAnnotations;
    private static final MethodDetails EMPTY_METHOD_DEFAULTS_MEMBER = new MethodDetails(ImmutableMap.of(), false);
    private static final MethodDetails EMPTY_METHOD_DEFAULTS_STATIC = new MethodDetails(ImmutableMap.of(), true);

    private ClassStructure(String className, int access, String superName, String[] interfaceNames) {
        this.type = Type.getObjectType(className);
        this.access = access;
        this.superName = superName;
        this.interfaces = interfaceNames;
    }

    public int getAccess() {
        return this.access;
    }

    public String getSuperName() {
        return this.superName;
    }

    public Type getType() {
        return this.type;
    }

    public Set<Method> getMethods() {
        return this.methods.keySet();
    }

    public Map<String, FieldNode> getFields() {
        return this.fields;
    }

    public Map<String, AnnotationDetails> getMethodAnnotations(Method method) {
        MethodDetails methodDetails = this.methods.get(method);
        if (methodDetails == null) {
            return Collections.emptyMap();
        }
        return methodDetails.annotations;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public Map<String, AnnotationDetails> getClassAnnotations() {
        return this.classAnnotations;
    }

    public String toString() {
        return this.type.getClassName();
    }

    public static ClassStructure getClassStructure(URL url) throws IOException {
        return ClassStructure.getClassStructure(url, 1);
    }

    public static ClassStructure getClassStructure(URL url, int flags) throws IOException {
        return ClassStructure.getClassStructure(Utils.getClassReaderFromResource(url.getPath(), url), flags);
    }

    public static ClassStructure getClassStructure(ClassReader cr, int flags) throws IOException {
        ClassStructure structure = new ClassStructure(cr.getClassName(), cr.getAccess(), cr.getSuperName(), cr.getInterfaces());
        ClassVisitor cv = structure.createClassVisitor(flags);
        if (cv != null) {
            cr.accept(cv, 1);
        }
        structure.methods = structure.methods == null ? Collections.emptyMap() : Collections.unmodifiableMap(structure.methods);
        structure.classAnnotations = structure.classAnnotations == null ? Collections.emptyMap() : Collections.unmodifiableMap(structure.classAnnotations);
        structure.fields = structure.fields == null ? Collections.emptyMap() : Collections.unmodifiableMap(structure.fields);
        return structure;
    }

    private ClassVisitor createClassVisitor(final int flags) {
        ClassVisitor cv = null;
        if (ClassStructure.isMethodFlagSet(flags)) {
            cv = new ClassVisitor(458752, cv){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (null == ClassStructure.this.methods) {
                        ClassStructure.this.methods = new HashMap();
                    }
                    boolean isStatic = (access & 8) == 8;
                    Method method = new Method(name, desc);
                    if ((flags & 8) == 8) {
                        final MethodDetails details = new MethodDetails(new HashMap<String, AnnotationDetails>(), isStatic);
                        ClassStructure.this.methods.put(method, details);
                        return new MethodVisitor(458752, super.visitMethod(access, name, desc, signature, exceptions)){

                            @Override
                            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                                AnnotationDetails annotation = new AnnotationDetails(super.visitAnnotation(desc, visible), desc);
                                details.annotations.put(desc, annotation);
                                return annotation;
                            }
                        };
                    }
                    ClassStructure.this.methods.put(method, isStatic ? EMPTY_METHOD_DEFAULTS_STATIC : EMPTY_METHOD_DEFAULTS_MEMBER);
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            };
        }
        if ((flags & 4) == 4) {
            cv = new ClassVisitor(458752, cv){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (null == ClassStructure.this.classAnnotations) {
                        ClassStructure.this.classAnnotations = new HashMap<String, AnnotationDetails>();
                    }
                    AnnotationDetails annotation = new AnnotationDetails(super.visitAnnotation(desc, visible), desc);
                    ClassStructure.this.classAnnotations.put(desc, annotation);
                    return annotation;
                }
            };
        }
        if (ClassStructure.isFieldFlagSet(flags)) {
            cv = new ClassVisitor(458752, cv){

                @Override
                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    SynchronizedFieldNode field = new SynchronizedFieldNode(access, name, desc, signature, value);
                    if (ClassStructure.this.fields == null) {
                        ClassStructure.this.fields = new HashMap();
                    }
                    ClassStructure.this.fields.put(name, field);
                    return super.visitField(access, name, desc, signature, value);
                }
            };
        }
        return cv;
    }

    public static ClassStructure getClassStructure(Class<?> clazz) {
        return ClassStructure.getClassStructure(clazz, 1);
    }

    public static ClassStructure getClassStructure(final Class<?> clazz, final int flags) {
        Annotation[] annotations;
        int access = 0;
        int modifiers = clazz.getModifiers();
        String superName = null;
        if (clazz.isAnnotation()) {
            access |= 0x2200;
            if (!Modifier.isPrivate(modifiers)) {
                access |= 1;
            }
            superName = "java/lang/Object";
        } else if (clazz.isInterface()) {
            access |= 0x200;
            superName = "java/lang/Object";
        } else {
            access = clazz.isEnum() ? (access |= 0x4020) : (access |= 0x20);
        }
        if (Modifier.isAbstract(modifiers)) {
            access |= 0x400;
        }
        if (!clazz.isAnnotation()) {
            if (Modifier.isPublic(modifiers)) {
                access |= 1;
            } else if (Modifier.isPrivate(modifiers)) {
                access |= 2;
            } else if (Modifier.isProtected(modifiers)) {
                access |= 4;
            }
        }
        if (Modifier.isFinal(modifiers)) {
            access |= 0x10;
        }
        if (clazz.getSuperclass() != null) {
            superName = Type.getType(clazz.getSuperclass()).getInternalName();
        }
        String[] interfaces = new String[clazz.getInterfaces().length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = Type.getType(clazz.getInterfaces()[i]).getInternalName();
        }
        final ClassStructure structure = new ClassStructure(Type.getType(clazz).getInternalName(), access, superName, interfaces);
        if ((flags & 4) == 4 && (annotations = clazz.getAnnotations()).length > 0) {
            structure.classAnnotations = new HashMap<String, AnnotationDetails>();
            for (Annotation annotation : annotations) {
                AnnotationDetails annotationDetails = ClassStructure.getAnnotationDetails(annotation);
                structure.classAnnotations.put(annotationDetails.desc, annotationDetails);
            }
        }
        if (structure.classAnnotations == null) {
            structure.classAnnotations = Collections.emptyMap();
        }
        if (ClassStructure.isFieldFlagSet(flags)) {
            structure.fields = new HashMap<String, FieldNode>();
            Field[] declaredFields = ClassReflection.getDeclaredFields(clazz);
            for (Field f : declaredFields) {
                SynchronizedFieldNode field = new SynchronizedFieldNode(0, f.getName(), Type.getDescriptor(f.getDeclaringClass()), null, null);
                structure.fields.put(f.getName(), field);
            }
        } else {
            structure.fields = ImmutableMap.of();
        }
        if (ClassStructure.isMethodFlagSet(flags)) {
            structure.methods = new HashMap<Method, MethodDetails>();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() {
                        java.lang.reflect.Method[] methods;
                        for (java.lang.reflect.Method m : methods = ClassReflection.getDeclaredMethods((Class)clazz)) {
                            structure.methods.put(Method.getMethod(m), ClassStructure.getMethodDetails(m, flags, Modifier.isStatic(m.getModifiers())));
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                Agent.LOG.log(Level.FINEST, "Error getting methods of " + clazz.getName(), ex);
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() {
                        Constructor[] constructors;
                        for (Constructor c : constructors = ClassReflection.getDeclaredConstructors((Class)clazz)) {
                            structure.methods.put(Method.getMethod(c), ClassStructure.getMethodDetails(c, flags, false));
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                Agent.LOG.log(Level.FINEST, "Error getting constructors of " + clazz.getName(), ex);
            }
        }
        return structure;
    }

    private static boolean isMethodFlagSet(int flags) {
        return (flags & 9) > 0;
    }

    private static boolean isFieldFlagSet(int flags) {
        return (flags & 2) > 0;
    }

    private static MethodDetails getMethodDetails(AccessibleObject method, int flags, boolean isStatic) {
        if ((flags & 8) == 8) {
            MethodDetails details = new MethodDetails(new HashMap<String, AnnotationDetails>(), isStatic);
            for (Annotation annotation : method.getAnnotations()) {
                AnnotationDetails annotationDetails = ClassStructure.getAnnotationDetails(annotation);
                details.annotations.put(annotationDetails.desc, annotationDetails);
            }
            return details;
        }
        return isStatic ? EMPTY_METHOD_DEFAULTS_STATIC : EMPTY_METHOD_DEFAULTS_MEMBER;
    }

    private static AnnotationDetails getAnnotationDetails(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        String annotationDesc = Type.getDescriptor(annotationType);
        AnnotationDetails node = new AnnotationDetails(null, annotationDesc);
        for (java.lang.reflect.Method annotationMethod : annotationType.getDeclaredMethods()) {
            try {
                Object value = annotationMethod.invoke((Object)annotation, new Object[0]);
                node.getOrCreateAttributes().put(annotationMethod.getName(), value);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINEST, "Error getting annotation value for " + annotationMethod.getName(), e);
            }
        }
        return node;
    }

    private static class MethodDetails {
        final Map<String, AnnotationDetails> annotations;
        final boolean isStatic;

        public MethodDetails(Map<String, AnnotationDetails> annotations, boolean isStatic) {
            this.annotations = annotations;
            this.isStatic = isStatic;
        }
    }
}

