/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.api.agent.Request;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ServletUtils {
    private ServletUtils() {
    }

    public static void recordParameters(Transaction tx, Request request) {
        if (tx.isIgnore()) {
            return;
        }
        if (!ServiceFactory.getAttributesService().captureRequestParams(tx.getApplicationName())) {
            return;
        }
        Map<String, String> requestParameters = ServletUtils.getRequestParameterMap(request);
        if (requestParameters.isEmpty()) {
            return;
        }
        tx.getPrefixedAgentAttributes().put("request.parameters.", requestParameters);
    }

    static Map<String, String> getRequestParameterMap(Request request) {
        Enumeration nameEnumeration = request.getParameterNames();
        if (nameEnumeration == null || !nameEnumeration.hasMoreElements()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        while (nameEnumeration.hasMoreElements()) {
            String name = nameEnumeration.nextElement().toString();
            if (name.length() > 255) {
                Agent.LOG.log(Level.FINER, "Rejecting request parameter with key \"{0}\" because the key is over the size limit of {1}", name, 255);
                continue;
            }
            String[] values = request.getParameterValues(name);
            String value = ServletUtils.getValue(values);
            if (value == null) continue;
            requestParameters.put(name, value);
        }
        return requestParameters;
    }

    private static String getValue(String[] values) {
        String value;
        if (values == null || values.length == 0) {
            return null;
        }
        String string = value = values.length == 1 ? values[0] : Arrays.asList(values).toString();
        if (value != null && value.length() > 255) {
            value = values.length == 1 ? value.substring(0, 255) : value.substring(0, 254) + ']';
        }
        return value;
    }
}

