/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.errors.ErrorAnalyzer;
import com.newrelic.agent.errors.ErrorMessageReplacer;
import com.newrelic.agent.errors.ReportableError;
import com.newrelic.agent.model.SpanError;
import com.newrelic.agent.tracers.ErrorTracer;
import com.newrelic.agent.transaction.TransactionThrowable;
import java.util.Objects;

public class SpanErrorBuilder {
    private final ErrorAnalyzer analyzer;
    private final ErrorMessageReplacer messageReplacer;

    public SpanErrorBuilder(ErrorAnalyzer analyzer, ErrorMessageReplacer messageReplacer) {
        this.analyzer = analyzer == null ? ErrorAnalyzer.DEFAULT : analyzer;
        this.messageReplacer = messageReplacer;
    }

    public SpanError buildSpanError(ErrorTracer tracer, boolean isRoot, int responseStatus, String statusMessage, TransactionThrowable transactionThrowable) {
        int statusCode;
        Throwable throwable = this.extractThrowable(tracer, transactionThrowable);
        int n = statusCode = isRoot ? responseStatus : 0;
        if (this.analyzer.isIgnoredError(statusCode, throwable)) {
            return new SpanError();
        }
        if (!this.isErrorSetByAPI(tracer) && !this.analyzer.isReportable(statusCode, throwable)) {
            return new SpanError();
        }
        SpanError result = new SpanError();
        result.setExpectedError(this.identifyExpectedError(statusCode, transactionThrowable));
        if (this.analyzer.isReportable(statusCode)) {
            result.setErrorStatus(statusCode);
            result.setErrorMessage(statusMessage);
        }
        if (throwable != null) {
            result.setErrorMessage(this.identifyErrorMessage(tracer, throwable));
            result.setErrorClass(this.identifyErrorClass(throwable));
        }
        return result;
    }

    private boolean identifyExpectedError(int statusCode, TransactionThrowable transactionThrowable) {
        return this.analyzer.isExpectedError(statusCode, transactionThrowable);
    }

    private Class<?> identifyErrorClass(Throwable throwable) {
        return throwable == null || throwable instanceof ReportableError ? null : throwable.getClass();
    }

    private String identifyErrorMessage(ErrorTracer tracer, Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (this.isErrorSetByAPI(tracer)) {
            return throwable.getMessage();
        }
        return this.messageReplacer.getMessage(throwable);
    }

    private boolean isErrorSetByAPI(ErrorTracer tracer) {
        return tracer.getException() != null && tracer.wasExceptionSetByAPI();
    }

    private Throwable extractThrowable(ErrorTracer tracer, TransactionThrowable transactionThrowable) {
        if (tracer.getException() != null) {
            return tracer.getException();
        }
        if (transactionThrowable != null && Objects.equals(transactionThrowable.spanId, tracer.getGuid())) {
            return transactionThrowable.throwable;
        }
        return null;
    }

    public boolean areErrorsEnabled() {
        return this.analyzer.areErrorsEnabled();
    }
}

