/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.dom;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.extension.beans.Extension;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExtensionDomParser {
    private static final ErrorHandler LOGGING_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Agent.LOG.log(Level.FINEST, exception.toString(), exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Agent.LOG.log(Level.FINER, exception.toString(), exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Agent.LOG.log(Level.FINEST, exception.toString(), exception);
        }
    };
    private static final ErrorHandler IGNORE_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }
    };
    private static final String NAMESPACE = "https://newrelic.com/docs/java/xsd/v1.0";
    private static final DocumentBuilderFactory documentFactory = ExtensionDomParser.initializeDocumentFactory();
    private static final DocumentBuilderFactory schemaDocumentFactory = ExtensionDomParser.initializeSchemaDocumentFactory();

    private static DocumentBuilderFactory initializeDocumentFactory() {
        DocumentBuilderFactory factory;
        try {
            factory = ExtensionDomParser.getDocumentBuilderFactory();
        }
        catch (Throwable e) {
            factory = ExtensionDomParser.getAndSetupDocumentBuilderComSunFactory();
        }
        return factory;
    }

    private static DocumentBuilderFactory initializeSchemaDocumentFactory() {
        DocumentBuilderFactory factory = documentFactory;
        try {
            Schema schema = ExtensionDomParser.getSchema();
            factory.setSchema(schema);
        }
        catch (Throwable e) {
            factory = null;
            Agent.LOG.log(Level.FINE, "Unable to initialize schema", e);
        }
        return factory;
    }

    public static Extension readStringGatherExceptions(String xml, List<Exception> exceptions) {
        if (xml == null || xml.length() == 0) {
            Agent.LOG.log(Level.FINE, "The input xml string is empty.");
            return null;
        }
        try {
            return ExtensionDomParser.parseDocument(xml, false);
        }
        catch (Exception e) {
            exceptions.add(e);
            return null;
        }
    }

    public static Extension readStringCatchException(String xml) {
        if (xml == null || xml.length() == 0) {
            Agent.LOG.log(Level.FINE, "The input xml string is empty.");
            return null;
        }
        try {
            return ExtensionDomParser.parseDocument(xml, false);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, MessageFormat.format("Failed to read extension {0}. Skipping the extension. Reason: {1}", xml, e.getMessage()));
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Reason For Failure: " + e.getMessage(), e);
            }
            return null;
        }
    }

    public static Extension readFileCatchException(File file) {
        try {
            return ExtensionDomParser.readFile(file);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, MessageFormat.format("Failed to read extension {0}. Skipping the extension. Reason: {1}", file.getName(), e.getMessage()));
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Reason For Failure: " + e.getMessage(), e);
            }
            return null;
        }
    }

    public static Extension readFile(File file) throws SAXException, IOException, ParserConfigurationException, NoSuchMethodException, SecurityException {
        return ExtensionDomParser.parseDocument(ExtensionDomParser.inputStreamToString(new FileInputStream(file)), true);
    }

    public static Extension readFile(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, NoSuchMethodException, SecurityException {
        return ExtensionDomParser.parseDocument(ExtensionDomParser.inputStreamToString(inputStream), true);
    }

    public static Extension parseDocument(String extensionXML, boolean setSchema) throws SAXException, IOException, ParserConfigurationException, NoSuchMethodException, SecurityException {
        Document doc = ExtensionDomParser.getDocument(extensionXML, setSchema);
        ExtensionDomParser.trimTextNodeWhitespace(doc.getDocumentElement());
        doc = ExtensionDomParser.fixNamespace(doc);
        Schema schema = schemaDocumentFactory.getSchema();
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(doc));
        try {
            Extension extension = new Extension();
            NodeList extensionElements = doc.getElementsByTagNameNS("*", "extension");
            if (extensionElements != null && extensionElements.getLength() == 1) {
                Node extensionElement = extensionElements.item(0);
                extension.setName(ExtensionDomParser.getAttribute("name", extensionElement, null));
                extension.setVersion(Double.parseDouble(ExtensionDomParser.getAttribute("version", extensionElement, "1.0")));
                extension.setEnabled(Boolean.valueOf(ExtensionDomParser.getAttribute("enabled", extensionElement, "true")));
                NodeList extensionChildNodes = extensionElement.getChildNodes();
                Node instrumentationElement = ExtensionDomParser.getFirstInstrumentationNode(extensionChildNodes);
                if (instrumentationElement != null) {
                    Extension.Instrumentation instrumentation = new Extension.Instrumentation();
                    instrumentation.setMetricPrefix(ExtensionDomParser.getAttribute("metricPrefix", instrumentationElement, null));
                    extension.setInstrumentation(instrumentation);
                    List<Extension.Instrumentation.Pointcut> pointcuts = instrumentation.getPointcut();
                    NodeList instrumentationChildNodes = instrumentationElement.getChildNodes();
                    for (int i = 0; i < instrumentationChildNodes.getLength(); ++i) {
                        Node instrumentationChildNode = instrumentationChildNodes.item(i);
                        if (!instrumentationChildNode.getNodeName().equals("pointcut") && !instrumentationChildNode.getNodeName().endsWith(":pointcut")) continue;
                        Extension.Instrumentation.Pointcut pointcut = new Extension.Instrumentation.Pointcut();
                        pointcut.setExcludeFromTransactionTrace(Boolean.valueOf(ExtensionDomParser.getAttribute("excludeFromTransactionTrace", instrumentationChildNode, "false")));
                        pointcut.setLeaf(Boolean.valueOf(ExtensionDomParser.getAttribute("leaf", instrumentationChildNode, "false")));
                        pointcut.setIgnoreTransaction(Boolean.valueOf(ExtensionDomParser.getAttribute("ignoreTransaction", instrumentationChildNode, "false")));
                        pointcut.setMetricNameFormat(ExtensionDomParser.getAttribute("metricNameFormat", instrumentationChildNode, null));
                        pointcut.setTransactionStartPoint(Boolean.valueOf(ExtensionDomParser.getAttribute("transactionStartPoint", instrumentationChildNode, "false")));
                        pointcut.setTransactionType(ExtensionDomParser.getAttribute("transactionType", instrumentationChildNode, null));
                        List<Extension.Instrumentation.Pointcut.Method> methods = pointcut.getMethod();
                        NodeList pointcutChildNodes = instrumentationChildNode.getChildNodes();
                        for (int p = 0; p < pointcutChildNodes.getLength(); ++p) {
                            Node node = pointcutChildNodes.item(p);
                            if (node.getNodeName().equals("className") || node.getNodeName().endsWith(":className")) {
                                Extension.Instrumentation.Pointcut.ClassName className = new Extension.Instrumentation.Pointcut.ClassName();
                                className.setIncludeSubclasses(Boolean.valueOf(ExtensionDomParser.getAttribute("includeSubclasses", node, "false")));
                                className.setValue(node.getTextContent());
                                pointcut.setClassName(className);
                                continue;
                            }
                            if (node.getNodeName().equals("interfaceName") || node.getNodeName().endsWith(":interfaceName")) {
                                pointcut.setInterfaceName(node.getTextContent());
                                continue;
                            }
                            if (node.getNodeName().equals("methodAnnotation") || node.getNodeName().endsWith(":methodAnnotation")) {
                                pointcut.setMethodAnnotation(node.getTextContent());
                                continue;
                            }
                            if (node.getNodeName().equals("method") || node.getNodeName().endsWith(":method")) {
                                NodeList methodChildNodes = node.getChildNodes();
                                Extension.Instrumentation.Pointcut.Method method = new Extension.Instrumentation.Pointcut.Method();
                                for (int m = 0; m < methodChildNodes.getLength(); ++m) {
                                    Node methodChildNode = methodChildNodes.item(m);
                                    if (methodChildNode.getNodeName().equals("name") || methodChildNode.getNodeName().endsWith(":name")) {
                                        method.setName(methodChildNode.getTextContent());
                                        continue;
                                    }
                                    if (methodChildNode.getNodeName().equals("returnType") || methodChildNode.getNodeName().endsWith(":returnType")) {
                                        method.setReturnType(methodChildNode.getTextContent());
                                        continue;
                                    }
                                    if (!methodChildNode.getNodeName().equals("parameters") && !methodChildNode.getNodeName().endsWith(":parameters")) continue;
                                    Extension.Instrumentation.Pointcut.Method.Parameters parameters = new Extension.Instrumentation.Pointcut.Method.Parameters();
                                    List<Extension.Instrumentation.Pointcut.Method.Parameters.Type> types = parameters.getType();
                                    NodeList parametersChildNodes = methodChildNode.getChildNodes();
                                    for (int p1 = 0; p1 < parametersChildNodes.getLength(); ++p1) {
                                        Node typeNode = parametersChildNodes.item(p1);
                                        if (!typeNode.getNodeName().equals("type") && !typeNode.getNodeName().endsWith(":type")) continue;
                                        Extension.Instrumentation.Pointcut.Method.Parameters.Type type = new Extension.Instrumentation.Pointcut.Method.Parameters.Type();
                                        type.setAttributeName(ExtensionDomParser.getAttribute("attributeName", typeNode, null));
                                        type.setValue(typeNode.getTextContent());
                                        types.add(type);
                                    }
                                    method.setParameters(parameters);
                                }
                                methods.add(method);
                                continue;
                            }
                            if (!node.getNodeName().equals("nameTransaction") && !node.getNodeName().endsWith(":nameTransaction")) continue;
                            pointcut.setNameTransaction(new Extension.Instrumentation.Pointcut.NameTransaction());
                        }
                        pointcuts.add(pointcut);
                    }
                }
            }
            return extension;
        }
        catch (Exception ex) {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                String xmlString = result.getWriter().toString();
                System.out.println(xmlString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new IOException(ex);
        }
    }

    private static Node getFirstInstrumentationNode(NodeList extensionChildNodes) {
        for (int i = 0; i < extensionChildNodes.getLength(); ++i) {
            Node node = extensionChildNodes.item(i);
            if (!node.getNodeName().equals("instrumentation") && !node.getNodeName().endsWith(":instrumentation")) continue;
            return node;
        }
        return null;
    }

    private static String getAttribute(String attributeName, Node element, String defaultValue) {
        Node nameElement = element.getAttributes().getNamedItem(attributeName);
        if (nameElement != null) {
            String value = nameElement.getNodeValue();
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
        return defaultValue;
    }

    private static Document getDocument(String pXml, boolean setSchema) throws SAXException, IOException, ParserConfigurationException, NoSuchMethodException, SecurityException {
        try (ByteArrayInputStream baos = new ByteArrayInputStream(pXml.getBytes(StandardCharsets.UTF_8));){
            Document document = ExtensionDomParser.getDocument(new InputSource(baos), setSchema);
            return document;
        }
    }

    private static Document getDocument(File file) throws SAXException, IOException, ParserConfigurationException, NoSuchMethodException, SecurityException {
        try (FileInputStream fis = new FileInputStream(file);){
            Document document = ExtensionDomParser.getDocument(new InputSource(new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8))), true);
            return document;
        }
    }

    private static Schema getSchema() throws IOException, SAXException, ParserConfigurationException, NoSuchMethodException, SecurityException {
        URL schemaFile = AgentBridge.getAgent().getClass().getClassLoader().getResource("META-INF/extensions/extension.xsd");
        if (schemaFile == null) {
            throw new IOException("Unable to load the extension schema");
        }
        Agent.LOG.finest("Loading extension schema from " + schemaFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        DocumentBuilderFactory factory = documentFactory;
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(LOGGING_ERROR_HANDLER);
        Document schemaDoc = builder.parse(new InputSource(new BufferedReader(new InputStreamReader(schemaFile.openStream(), StandardCharsets.UTF_8))));
        return schemaFactory.newSchema(new DOMSource(schemaDoc));
    }

    private static Document getDocument(InputSource inputSource, boolean setSchema) throws SAXException, IOException, ParserConfigurationException, NoSuchMethodException, SecurityException {
        DocumentBuilderFactory factory = documentFactory;
        if (setSchema) {
            if (schemaDocumentFactory == null) {
                throw new IOException("Unable to initialize schema document factory");
            }
            factory = schemaDocumentFactory;
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(IGNORE_ERROR_HANDLER);
        return builder.parse(inputSource);
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException, NoSuchMethodException, SecurityException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            ExtensionDomParser.setupDocumentFactory(factory);
        }
        catch (AbstractMethodError e) {
            return ExtensionDomParser.getAndSetupDocumentBuilderComSunFactory();
        }
        return factory;
    }

    private static void setupDocumentFactory(DocumentBuilderFactory factory) throws ParserConfigurationException {
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
    }

    private static DocumentBuilderFactory getAndSetupDocumentBuilderComSunFactory() throws NoSuchMethodError {
        try {
            Class<?> clazz = AgentBridge.getAgent().getClass().getClassLoader().loadClass("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = (DocumentBuilderFactory)clazz.newInstance();
            ExtensionDomParser.setupDocumentFactory(factory);
            return factory;
        }
        catch (Throwable e) {
            Agent.LOG.info("Your application has loaded a Java 1.4 or below implementation of the class DocumentBuilderFactory. Please upgrade to a 1.5 version if you want to use Java agent XML instrumentation.");
            throw new NoSuchMethodError("The method setFeature can not be called.");
        }
    }

    public static void trimTextNodeWhitespace(Node e) {
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Text) {
                Text text = (Text)child;
                text.setData(text.getData().trim());
            }
            ExtensionDomParser.trimTextNodeWhitespace(child);
        }
    }

    private static Document fixNamespace(Document doc) {
        try {
            Transformer transformer = ExtensionDomParser.getTransformerFactory().newTransformer();
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            xmlString = xmlString.replace("xmlns:urn=\"newrelic-extension\"", "xmlns:urn=\"https://newrelic.com/docs/java/xsd/v1.0\"");
            return ExtensionDomParser.getDocument(xmlString, true);
        }
        catch (Exception ex) {
            return doc;
        }
    }

    private static TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        try {
            return TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError ex) {
            try {
                Class<?> clazz = AgentBridge.getAgent().getClass().getClassLoader().loadClass("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                Method method = clazz.getMethod("newTransformerFactoryNoServiceLoader", new Class[0]);
                return (TransformerFactory)method.invoke(null, new Object[0]);
            }
            catch (Exception e1) {
                try {
                    Class<?> clazz = AgentBridge.getAgent().getClass().getClassLoader().loadClass("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                    return (TransformerFactory)clazz.newInstance();
                }
                catch (Exception e2) {
                    throw ex;
                }
            }
        }
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }
}

