/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.async;

import com.newrelic.agent.deps.org.apache.logging.log4j.status.StatusLogger;
import com.newrelic.agent.deps.org.apache.logging.log4j.util.PropertiesUtil;

public enum ThreadNameCachingStrategy {
    CACHED{

        @Override
        public String getThreadName() {
            String result = (String)THREADLOCAL_NAME.get();
            if (result == null) {
                result = Thread.currentThread().getName();
                THREADLOCAL_NAME.set(result);
            }
            return result;
        }
    }
    ,
    UNCACHED{

        @Override
        public String getThreadName() {
            return Thread.currentThread().getName();
        }
    };

    private static final StatusLogger LOGGER;
    private static final ThreadLocal<String> THREADLOCAL_NAME;

    abstract String getThreadName();

    public static ThreadNameCachingStrategy create() {
        String defaultStrategy = System.getProperty("java.version").compareTo("1.8.0_102") < 0 ? "CACHED" : "UNCACHED";
        String name = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ThreadNameStrategy");
        try {
            ThreadNameCachingStrategy result = ThreadNameCachingStrategy.valueOf(name != null ? name : defaultStrategy);
            LOGGER.debug("AsyncLogger.ThreadNameStrategy={} (user specified {}, default is {})", (Object)result, (Object)name, (Object)defaultStrategy);
            return result;
        }
        catch (Exception ex) {
            LOGGER.debug("Using AsyncLogger.ThreadNameStrategy.{}: '{}' not valid: {}", (Object)defaultStrategy, (Object)name, (Object)ex.toString());
            return ThreadNameCachingStrategy.valueOf(defaultStrategy);
        }
    }

    static {
        LOGGER = StatusLogger.getLogger();
        THREADLOCAL_NAME = new ThreadLocal();
    }
}

