/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.jregex;

import com.newrelic.agent.deps.jregex.MatchResult;
import com.newrelic.agent.deps.jregex.Matcher;
import com.newrelic.agent.deps.jregex.PatternSyntaxException;
import com.newrelic.agent.deps.jregex.REFlags;
import com.newrelic.agent.deps.jregex.RETokenizer;
import com.newrelic.agent.deps.jregex.Replacer;
import com.newrelic.agent.deps.jregex.Substitution;
import com.newrelic.agent.deps.jregex.Term;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;

public class Pattern
implements Serializable,
REFlags {
    String stringRepr;
    Term root;
    Term root0;
    int memregs;
    int counters;
    int lookaheads;
    Hashtable namedGroupMap;

    protected Pattern() throws PatternSyntaxException {
    }

    public Pattern(String regex) throws PatternSyntaxException {
        this(regex, 0);
    }

    public Pattern(String regex, String flags) throws PatternSyntaxException {
        this.stringRepr = regex;
        this.compile(regex, Pattern.parseFlags(flags));
    }

    public Pattern(String regex, int flags) throws PatternSyntaxException {
        this.compile(regex, flags);
    }

    protected void compile(String regex, int flags) throws PatternSyntaxException {
        this.stringRepr = regex;
        Term.makeTree(regex, flags, this);
    }

    public int groupCount() {
        return this.memregs;
    }

    public Integer groupId(String name) {
        return (Integer)this.namedGroupMap.get(name);
    }

    public boolean matches(String s) {
        return this.matcher(s).matches();
    }

    public boolean startsWith(String s) {
        return this.matcher(s).matchesPrefix();
    }

    public Matcher matcher() {
        return new Matcher(this);
    }

    public Matcher matcher(String s) {
        Matcher m = new Matcher(this);
        m.setTarget(s);
        return m;
    }

    public Matcher matcher(char[] data, int start, int end) {
        Matcher m = new Matcher(this);
        m.setTarget(data, start, end);
        return m;
    }

    public Matcher matcher(MatchResult res, int groupId) {
        Matcher m = new Matcher(this);
        if (res instanceof Matcher) {
            m.setTarget((Matcher)res, groupId);
        } else {
            m.setTarget(res.targetChars(), res.start(groupId) + res.targetStart(), res.length(groupId));
        }
        return m;
    }

    public Matcher matcher(MatchResult res, String groupName) {
        Integer id = res.pattern().groupId(groupName);
        if (id == null) {
            throw new IllegalArgumentException("group not found:" + groupName);
        }
        int group = id;
        return this.matcher(res, group);
    }

    public Matcher matcher(Reader text, int length) throws IOException {
        Matcher m = new Matcher(this);
        m.setTarget(text, length);
        return m;
    }

    public Replacer replacer(String expr) {
        return new Replacer(this, expr);
    }

    public Replacer replacer(Substitution model) {
        return new Replacer(this, model);
    }

    public RETokenizer tokenizer(String text) {
        return new RETokenizer(this, text);
    }

    public RETokenizer tokenizer(char[] data, int off, int len) {
        return new RETokenizer(this, data, off, len);
    }

    public RETokenizer tokenizer(Reader in, int length) throws IOException {
        return new RETokenizer(this, in, length);
    }

    public String toString() {
        return this.stringRepr;
    }

    public String toString_d() {
        return this.root.toStringAll();
    }

    static int parseFlags(String flags) throws PatternSyntaxException {
        boolean enable = true;
        int len = flags.length();
        int result = 0;
        block4: for (int i = 0; i < len; ++i) {
            char c = flags.charAt(i);
            switch (c) {
                case '+': {
                    enable = true;
                    continue block4;
                }
                case '-': {
                    enable = false;
                    continue block4;
                }
                default: {
                    int flag = Pattern.getFlag(c);
                    if (enable) {
                        result |= flag;
                        continue block4;
                    }
                    result &= ~flag;
                }
            }
        }
        return result;
    }

    static int parseFlags(char[] data, int start, int len) throws PatternSyntaxException {
        boolean enable = true;
        int result = 0;
        block4: for (int i = 0; i < len; ++i) {
            char c = data[start + i];
            switch (c) {
                case '+': {
                    enable = true;
                    continue block4;
                }
                case '-': {
                    enable = false;
                    continue block4;
                }
                default: {
                    int flag = Pattern.getFlag(c);
                    if (enable) {
                        result |= flag;
                        continue block4;
                    }
                    result &= ~flag;
                }
            }
        }
        return result;
    }

    private static int getFlag(char c) throws PatternSyntaxException {
        switch (c) {
            case 'i': {
                return 1;
            }
            case 'm': {
                return 2;
            }
            case 's': {
                return 4;
            }
            case 'x': {
                return 8;
            }
            case 'u': {
                return 16;
            }
            case 'X': {
                return 32;
            }
        }
        throw new PatternSyntaxException("unknown flag: " + c);
    }
}

