/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.okhttp;

import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.io.grpc.ChannelLogger;
import com.newrelic.agent.deps.io.grpc.ExperimentalApi;
import com.newrelic.agent.deps.io.grpc.Internal;
import com.newrelic.agent.deps.io.grpc.internal.AbstractManagedChannelImplBuilder;
import com.newrelic.agent.deps.io.grpc.internal.AtomicBackoff;
import com.newrelic.agent.deps.io.grpc.internal.ClientTransportFactory;
import com.newrelic.agent.deps.io.grpc.internal.ConnectionClientTransport;
import com.newrelic.agent.deps.io.grpc.internal.GrpcUtil;
import com.newrelic.agent.deps.io.grpc.internal.KeepAliveManager;
import com.newrelic.agent.deps.io.grpc.internal.SharedResourceHolder;
import com.newrelic.agent.deps.io.grpc.internal.TransportTracer;
import com.newrelic.agent.deps.io.grpc.okhttp.OkHttpClientTransport;
import com.newrelic.agent.deps.io.grpc.okhttp.Utils;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.CipherSuite;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.ConnectionSpec;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.Platform;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.TlsVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public class OkHttpChannelBuilder
extends AbstractManagedChannelImplBuilder<OkHttpChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 65535;
    @VisibleForTesting
    static final ConnectionSpec INTERNAL_DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384).tlsVersions(TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final SharedResourceHolder.Resource<Executor> SHARED_EXECUTOR = new SharedResourceHolder.Resource<Executor>(){

        @Override
        public Executor create() {
            return Executors.newCachedThreadPool(GrpcUtil.getThreadFactory("grpc-okhttp-%d", true));
        }

        @Override
        public void close(Executor executor) {
            ((ExecutorService)executor).shutdown();
        }
    };
    private Executor transportExecutor;
    private ScheduledExecutorService scheduledExecutorService;
    private SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private ConnectionSpec connectionSpec = INTERNAL_DEFAULT_CONNECTION_SPEC;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private int flowControlWindow = 65535;
    private boolean keepAliveWithoutCalls;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;
    private final boolean useGetForSafeMethods = false;

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(host, port);
    }

    public static OkHttpChannelBuilder forTarget(String target) {
        return new OkHttpChannelBuilder(target);
    }

    protected OkHttpChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    private OkHttpChannelBuilder(String target) {
        super(target);
    }

    @VisibleForTesting
    final OkHttpChannelBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    public final OkHttpChannelBuilder transportExecutor(@Nullable Executor transportExecutor) {
        this.transportExecutor = transportExecutor;
        return this;
    }

    public final OkHttpChannelBuilder socketFactory(@Nullable SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    @Deprecated
    public final OkHttpChannelBuilder negotiationType(com.newrelic.agent.deps.io.grpc.okhttp.NegotiationType type) {
        Preconditions.checkNotNull(type, "type");
        switch (type) {
            case TLS: {
                this.negotiationType = NegotiationType.TLS;
                break;
            }
            case PLAINTEXT: {
                this.negotiationType = NegotiationType.PLAINTEXT;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown negotiation type: " + (Object)((Object)type)));
            }
        }
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime > 0L, "keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTimeout > 0L, "keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutNanos);
        return this;
    }

    public OkHttpChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkState(flowControlWindow > 0, "flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.keepAliveWithoutCalls = enable;
        return this;
    }

    public final OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public final OkHttpChannelBuilder hostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public final OkHttpChannelBuilder connectionSpec(com.newrelic.agent.deps.com.squareup.okhttp.ConnectionSpec connectionSpec) {
        Preconditions.checkArgument(connectionSpec.isTls(), "plaintext ConnectionSpec is not accepted");
        this.connectionSpec = Utils.convertSpec(connectionSpec);
        return this;
    }

    @Override
    public final OkHttpChannelBuilder usePlaintext() {
        this.negotiationType = NegotiationType.PLAINTEXT;
        return this;
    }

    @Override
    public final OkHttpChannelBuilder useTransportSecurity() {
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public final OkHttpChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService");
        return this;
    }

    @Override
    public OkHttpChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    @Override
    @Internal
    protected final ClientTransportFactory buildTransportFactory() {
        boolean enableKeepAlive = this.keepAliveTimeNanos != Long.MAX_VALUE;
        return new OkHttpTransportFactory(this.transportExecutor, this.scheduledExecutorService, this.socketFactory, this.createSslSocketFactory(), this.hostnameVerifier, this.connectionSpec, this.maxInboundMessageSize(), enableKeepAlive, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.flowControlWindow, this.keepAliveWithoutCalls, this.maxInboundMetadataSize, this.transportTracerFactory, false);
    }

    @Override
    protected int getDefaultPort() {
        switch (this.negotiationType) {
            case PLAINTEXT: {
                return 80;
            }
            case TLS: {
                return 443;
            }
        }
        throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
    }

    @Nullable
    @VisibleForTesting
    SSLSocketFactory createSslSocketFactory() {
        switch (this.negotiationType) {
            case TLS: {
                try {
                    if (this.sslSocketFactory == null) {
                        SSLContext sslContext = SSLContext.getInstance("Default", Platform.get().getProvider());
                        this.sslSocketFactory = sslContext.getSocketFactory();
                    }
                    return this.sslSocketFactory;
                }
                catch (GeneralSecurityException gse) {
                    throw new RuntimeException("TLS Provider failure", gse);
                }
            }
            case PLAINTEXT: {
                return null;
            }
        }
        throw new RuntimeException("Unknown negotiation type: " + (Object)((Object)this.negotiationType));
    }

    @Internal
    static final class OkHttpTransportFactory
    implements ClientTransportFactory {
        private final Executor executor;
        private final boolean usingSharedExecutor;
        private final boolean usingSharedScheduler;
        private final TransportTracer.Factory transportTracerFactory;
        private final SocketFactory socketFactory;
        @Nullable
        private final SSLSocketFactory sslSocketFactory;
        @Nullable
        private final HostnameVerifier hostnameVerifier;
        private final ConnectionSpec connectionSpec;
        private final int maxMessageSize;
        private final boolean enableKeepAlive;
        private final AtomicBackoff keepAliveTimeNanos;
        private final long keepAliveTimeoutNanos;
        private final int flowControlWindow;
        private final boolean keepAliveWithoutCalls;
        private final int maxInboundMetadataSize;
        private final ScheduledExecutorService timeoutService;
        private final boolean useGetForSafeMethods;
        private boolean closed;

        private OkHttpTransportFactory(Executor executor, @Nullable ScheduledExecutorService timeoutService, @Nullable SocketFactory socketFactory, @Nullable SSLSocketFactory sslSocketFactory, @Nullable HostnameVerifier hostnameVerifier, ConnectionSpec connectionSpec, int maxMessageSize, boolean enableKeepAlive, long keepAliveTimeNanos, long keepAliveTimeoutNanos, int flowControlWindow, boolean keepAliveWithoutCalls, int maxInboundMetadataSize, TransportTracer.Factory transportTracerFactory, boolean useGetForSafeMethods) {
            this.usingSharedScheduler = timeoutService == null;
            this.timeoutService = this.usingSharedScheduler ? SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE) : timeoutService;
            this.socketFactory = socketFactory;
            this.sslSocketFactory = sslSocketFactory;
            this.hostnameVerifier = hostnameVerifier;
            this.connectionSpec = connectionSpec;
            this.maxMessageSize = maxMessageSize;
            this.enableKeepAlive = enableKeepAlive;
            this.keepAliveTimeNanos = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.flowControlWindow = flowControlWindow;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.useGetForSafeMethods = useGetForSafeMethods;
            this.usingSharedExecutor = executor == null;
            this.transportTracerFactory = Preconditions.checkNotNull(transportTracerFactory, "transportTracerFactory");
            this.executor = this.usingSharedExecutor ? (Executor)SharedResourceHolder.get(SHARED_EXECUTOR) : executor;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveTimeNanos.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            InetSocketAddress inetSocketAddr = (InetSocketAddress)addr;
            OkHttpClientTransport transport = new OkHttpClientTransport(inetSocketAddr, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.executor, this.socketFactory, this.sslSocketFactory, this.hostnameVerifier, this.connectionSpec, this.maxMessageSize, this.flowControlWindow, options.getHttpConnectProxiedSocketAddress(), tooManyPingsRunnable, this.maxInboundMetadataSize, this.transportTracerFactory.create(), this.useGetForSafeMethods);
            if (this.enableKeepAlive) {
                transport.enableKeepAlive(true, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
            }
            return transport;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timeoutService;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.usingSharedScheduler) {
                SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timeoutService);
            }
            if (this.usingSharedExecutor) {
                SharedResourceHolder.release(SHARED_EXECUTOR, this.executor);
            }
        }
    }

    private static enum NegotiationType {
        TLS,
        PLAINTEXT;

    }
}

