/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.ExtendedTransactionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.bridge.NoOpDistributedTracePayload;
import com.newrelic.agent.bridge.TransportType;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.interfaces.SamplingPriorityQueue;
import com.newrelic.agent.model.PriorityAware;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.api.agent.DistributedTracePayload;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class DistributedTraceServiceImpl
extends AbstractService
implements DistributedTraceService,
ConnectionListener,
ExtendedTransactionListener,
HarvestListener,
AgentConfigListener {
    private static final int MAJOR_CAT_VERSION = 0;
    private static final int MINOR_CAT_VERSION = 1;
    private final AtomicReference<String> accountId = new AtomicReference();
    private final AtomicReference<String> applicationId = new AtomicReference();
    private final AtomicReference<String> trustKey = new AtomicReference();
    private final AtomicBoolean firstHarvest = new AtomicBoolean(true);
    private DistributedTracingConfig distributedTraceConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig();
    private static final ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat format = new DecimalFormat();
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            if (symbols.getDecimalSeparator() == ',') {
                format.applyLocalizedPattern("#,######");
            } else {
                format.applyPattern("#.######");
            }
            return format;
        }
    };

    public DistributedTraceServiceImpl() {
        super(DistributedTraceServiceImpl.class.getSimpleName());
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
    }

    @Override
    public boolean isEnabled() {
        return this.distributedTraceConfig.isEnabled();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getRPMServiceManager().addConnectionListener(this);
        ServiceFactory.getTransactionService().addTransactionListener(this);
        ServiceFactory.getHarvestService().addHarvestListener(this);
        if (this.isEnabled()) {
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/DistributedTracing");
            statsService.getMetricAggregator().incrementCounter(MessageFormat.format("Supportability/DistributedTracing/ExcludeNewRelicHeader/{0}", !this.distributedTraceConfig.isIncludeNewRelicHeader()));
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getRPMServiceManager().removeConnectionListener(this);
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void connected(IRPMService rpmService, AgentConfig agentConfig) {
        String trustedAccountKey;
        String accId;
        DistributedTracingConfig dtConfig = agentConfig.getDistributedTracingConfig();
        String appId = String.valueOf(dtConfig.getPrimaryApplicationId());
        if (appId != null) {
            this.applicationId.set(appId);
        }
        if ((accId = String.valueOf(dtConfig.getAccountId())) != null) {
            this.accountId.set(accId);
        }
        if ((trustedAccountKey = String.valueOf(dtConfig.getTrustedAccountKey())) != null) {
            this.trustKey.set(trustedAccountKey);
        } else {
            this.trustKey.set(this.getAccountId());
        }
        this.applicationId.compareAndSet(null, "0");
    }

    @Override
    public void disconnected(IRPMService rpmService) {
        this.accountId.set(null);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.firstHarvest.set(false);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public int getMajorSupportedCatVersion() {
        return 0;
    }

    @Override
    public int getMinorSupportedCatVersion() {
        return 1;
    }

    @Override
    public String getAccountId() {
        return this.accountId.get();
    }

    @Override
    public String getTrustKey() {
        if (this.trustKey.get() == null) {
            return this.getAccountId();
        }
        return this.trustKey.get();
    }

    @Override
    public String getApplicationId() {
        return this.applicationId.get();
    }

    @Override
    public <T extends PriorityAware> float calculatePriority(Float priority, SamplingPriorityQueue<T> reservoir) {
        if (priority == null) {
            boolean shouldSample;
            int target;
            if (reservoir == null) {
                return DistributedTraceServiceImpl.nextTruncatedFloat();
            }
            int seen = reservoir.getNumberOfTries();
            if (this.firstHarvest.get() || seen == 0) {
                if (seen <= reservoir.getTarget()) {
                    return DistributedTraceServiceImpl.nextTruncatedFloat() + 1.0f;
                }
                return DistributedTraceServiceImpl.nextTruncatedFloat();
            }
            int seenLast = reservoir.getDecidedLast();
            int sampled = reservoir.getSampled();
            if (sampled < (target = reservoir.getTarget())) {
                shouldSample = (seenLast <= 0 ? 0 : ThreadLocalRandom.current().nextInt(seenLast)) < target;
            } else if (sampled > target * 2) {
                shouldSample = false;
            } else {
                int expTarget = (int)(Math.pow(target, (float)target / (float)sampled) - Math.pow(target, 0.5));
                shouldSample = ThreadLocalRandom.current().nextInt(seen) < expTarget;
            }
            return DistributedTraceServiceImpl.nextTruncatedFloat() + (shouldSample ? 1.0f : 0.0f);
        }
        return priority.floatValue();
    }

    @Override
    public Map<String, Object> getIntrinsics(DistributedTracePayloadImpl inboundPayload, String guid, String traceId, TransportType transportType, long parentTransportDurationInMillis, long largestTransportDuration, String parentId, String parentSpanId, float priority) {
        HashMap<String, Object> intrinsicAttributes = new HashMap<String, Object>();
        try {
            if (transportType != null) {
                intrinsicAttributes.put("parent.transportType", transportType.name());
            }
            if (inboundPayload != null) {
                if (inboundPayload.parentType != null) {
                    intrinsicAttributes.put("parent.type", inboundPayload.parentType);
                }
                if (inboundPayload.applicationId != null) {
                    intrinsicAttributes.put("parent.app", inboundPayload.applicationId);
                }
                if (inboundPayload.accountId != null) {
                    intrinsicAttributes.put("parent.account", inboundPayload.accountId);
                }
                if (transportType != null) {
                    intrinsicAttributes.put("parent.transportType", transportType.name());
                }
                if (parentTransportDurationInMillis >= 0L) {
                    float transportDurationSec = (float)parentTransportDurationInMillis / 1000.0f;
                    intrinsicAttributes.put("parent.transportDuration", Float.valueOf(transportDurationSec));
                }
            }
            if (guid != null) {
                intrinsicAttributes.put("guid", guid);
            }
            if (traceId != null) {
                intrinsicAttributes.put("traceId", traceId);
            }
            intrinsicAttributes.put("priority", Float.valueOf(priority));
            intrinsicAttributes.put("sampled", DistributedTraceUtil.isSampledPriority(priority));
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Failed to retrieve distributed trace intrinsics.");
        }
        return intrinsicAttributes;
    }

    @Override
    public void dispatcherTransactionStarted(Transaction transaction) {
    }

    @Override
    public void dispatcherTransactionCancelled(Transaction transaction) {
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        if (this.distributedTraceConfig.isEnabled()) {
            Map<String, Object> distributedTracingIntrinsics = this.getIntrinsics(transactionData.getInboundDistributedTracePayload(), transactionData.getGuid(), transactionData.getTraceId(), transactionData.getTransportType(), transactionData.getTransportDurationInMillis(), transactionData.getLargestTransportDurationInMillis(), transactionData.getParentId(), transactionData.getParentSpanId(), transactionData.getPriority());
            transactionData.getIntrinsicAttributes().putAll(distributedTracingIntrinsics);
            this.recordMetrics(transactionData, transactionStats);
        }
    }

    public static float nextTruncatedFloat() {
        float next = 0.0f;
        try {
            next = Float.parseFloat(FORMATTER.get().format(ThreadLocalRandom.current().nextFloat()).replace(',', '.'));
        }
        catch (NumberFormatException e) {
            Agent.LOG.log(Level.WARNING, "Unable to create priority value", e);
        }
        return next;
    }

    private void recordMetrics(TransactionData transactionData, TransactionStats transactionStats) {
        DistributedTracePayloadImpl payload = transactionData.getInboundDistributedTracePayload();
        if (payload == null) {
            transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(MessageFormat.format("DurationByCaller/Unknown/Unknown/Unknown/{0}/all", transactionData.getTransportType())).recordResponseTimeInNanos(transactionData.getTransactionTime().getResponseTimeInNanos());
            if (transactionData.isWebTransaction()) {
                transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(MessageFormat.format("DurationByCaller/Unknown/Unknown/Unknown/{0}/allWeb", transactionData.getTransportType())).recordResponseTimeInNanos(transactionData.getTransactionTime().getResponseTimeInNanos());
            }
            if (transactionData.hasReportableErrorThatIsNotIgnored()) {
                transactionStats.getUnscopedStats().getStats(MessageFormat.format("ErrorsByCaller/Unknown/Unknown/Unknown/{0}/all", transactionData.getTransportType())).incrementCallCount();
            }
        } else {
            String txType = "allOther";
            if (transactionData.isWebTransaction()) {
                txType = "allWeb";
            }
            String parentDurationAll = MessageFormat.format("DurationByCaller/{0}/{1}/{2}/{3}/{4}", payload.parentType, payload.accountId, payload.applicationId, transactionData.getTransportType().name(), "all");
            String parentDurationByType = MessageFormat.format("DurationByCaller/{0}/{1}/{2}/{3}/{4}", payload.parentType, payload.accountId, payload.applicationId, transactionData.getTransportType().name(), txType);
            long transactionResponseTime = transactionData.getTransactionTime().getResponseTimeInNanos();
            transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(parentDurationAll).recordResponseTimeInNanos(transactionResponseTime);
            transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(parentDurationByType).recordResponseTimeInNanos(transactionResponseTime);
            String transportDurationAll = MessageFormat.format("TransportDuration/{0}/{1}/{2}/{3}/{4}", payload.parentType, payload.accountId, payload.applicationId, transactionData.getTransportType().name(), "all");
            String transportDurationByType = MessageFormat.format("TransportDuration/{0}/{1}/{2}/{3}/{4}", payload.parentType, payload.accountId, payload.applicationId, transactionData.getTransportType().name(), txType);
            long transportDuration = transactionData.getTransportDurationInMillis();
            transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(transportDurationAll).recordResponseTime(transportDuration, TimeUnit.MILLISECONDS);
            transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(transportDurationByType).recordResponseTime(transportDuration, TimeUnit.MILLISECONDS);
            if (transactionData.hasReportableErrorThatIsNotIgnored()) {
                String errorsByParentAll = MessageFormat.format("ErrorsByCaller/{0}/{1}/{2}/{3}/{4}", payload.parentType, payload.accountId, payload.applicationId, transactionData.getTransportType().name(), "all");
                String errorsByParentByType = MessageFormat.format("ErrorsByCaller/{0}/{1}/{2}/{3}/{4}", payload.parentType, payload.accountId, payload.applicationId, transactionData.getTransportType().name(), txType);
                transactionStats.getUnscopedStats().getStats(errorsByParentAll).incrementCallCount();
                transactionStats.getUnscopedStats().getStats(errorsByParentByType).incrementCallCount();
            }
        }
    }

    @Override
    public DistributedTracePayload createDistributedTracePayload(Tracer tracer) {
        DistributedTracePayloadImpl distributedTracePayload;
        if (tracer == null) {
            return NoOpDistributedTracePayload.INSTANCE;
        }
        Transaction tx = tracer.getTransactionActivity().getTransaction();
        String spanId = null;
        boolean spansEnabled = ServiceFactory.getConfigService().getDefaultAgentConfig().getSpanEventsConfig().isEnabled();
        boolean sampled = DistributedTraceUtil.isSampledPriority(tx.getPriority());
        if (sampled && spansEnabled) {
            Tracer tracerWithSpan = AbstractTracer.getParentTracerWithSpan(tracer);
            String string = spanId = tracerWithSpan != null ? tracerWithSpan.getGuid() : null;
        }
        if ((distributedTracePayload = tx.createDistributedTracePayload(spanId)) == null) {
            return NoOpDistributedTracePayload.INSTANCE;
        }
        return distributedTracePayload;
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        boolean wasEnabled = this.isEnabled();
        this.distributedTraceConfig = agentConfig.getDistributedTracingConfig();
        if (!wasEnabled && this.isEnabled()) {
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/DistributedTracing");
            statsService.getMetricAggregator().incrementCounter(MessageFormat.format("Supportability/DistributedTracing/ExcludeNewRelicHeader/{0}", !this.distributedTraceConfig.isIncludeNewRelicHeader()));
        }
    }
}

