/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.service.module.JarAnalystFactory;
import com.newrelic.api.agent.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ClassNoticingFactory
implements ClassMatchVisitorFactory {
    private final JarAnalystFactory jarAnalystFactory;
    private final ExecutorService executorService;
    private final Logger logger;
    private final Set<String> seenPaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger classSeenCount = new AtomicInteger(0);

    public ClassNoticingFactory(JarAnalystFactory jarAnalystFactory, ExecutorService executorService, Logger logger) {
        this.jarAnalystFactory = jarAnalystFactory;
        this.executorService = executorService;
        this.logger = logger;
    }

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
        URL codeSourceLocation = context.getCodeSourceLocation();
        if (codeSourceLocation != null) {
            this.addURL(codeSourceLocation);
        }
        return null;
    }

    public void addURL(URL url) {
        this.classSeenCount.incrementAndGet();
        try {
            this.addSingleURL(url);
        }
        catch (MalformedURLException exception) {
            this.logger.log(Level.FINEST, (Throwable)exception, "{0} unable to process url", (Object)url);
        }
    }

    private void addSingleURL(URL url) throws MalformedURLException {
        if ("jar".equals(url.getProtocol())) {
            this.addJarProtocolURL(url);
        } else if (url.getFile().endsWith(".jar")) {
            this.addURLEndingWithJar(url);
        } else {
            this.addOtherURL(url);
        }
    }

    private void addOtherURL(URL url) throws MalformedURLException {
        String path;
        int jarIndex = url.getFile().lastIndexOf(".jar");
        if (jarIndex > 0 && this.seenPaths.add(path = url.getFile().substring(0, jarIndex + ".jar".length()))) {
            URL finalUrl = new URL(url.getProtocol(), url.getHost(), path);
            this.executorService.submit(this.jarAnalystFactory.createURLAnalyzer(finalUrl));
            this.logger.log(Level.FINEST, "{0} offered to analysis queue; {1} paths seen and {2} classes seen.", (Object)finalUrl, (Object)this.seenPaths.size(), (Object)this.classSeenCount.get());
        }
    }

    private void addJarProtocolURL(URL url) throws MalformedURLException {
        String path = url.getFile();
        int index = path.lastIndexOf(".jar");
        if (index > 0) {
            path = path.substring(0, index + ".jar".length());
        }
        if (this.seenPaths.add(path)) {
            this.executorService.submit(this.jarAnalystFactory.createURLAnalyzer(new URL(path)));
            this.logger.log(Level.FINEST, "{0} offered to analysis queue; {1} paths seen and {2} classes seen.", (Object)url, (Object)this.seenPaths.size(), (Object)this.classSeenCount.get());
        }
    }

    private void addURLEndingWithJar(URL url) {
        if (this.seenPaths.add(url.getFile())) {
            this.executorService.submit(this.jarAnalystFactory.createURLAnalyzer(url));
            this.logger.log(Level.FINEST, "{0} offered to analysis queue; {1} paths seen and {2} classes seen.", (Object)url, (Object)this.seenPaths.size(), (Object)this.classSeenCount.get());
        }
    }
}

