/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.deps.org.yaml.snakeyaml.Yaml;
import com.newrelic.agent.deps.org.yaml.snakeyaml.constructor.Constructor;
import com.newrelic.agent.deps.org.yaml.snakeyaml.nodes.Tag;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.extension.XmlExtension;
import com.newrelic.agent.extension.YamlExtension;
import com.newrelic.agent.extension.dom.ExtensionDomParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class ExtensionParsers {
    private final ExtensionParser yamlParser;
    private final ExtensionParser xmlParser;

    public ExtensionParsers(final List<ConfigurationConstruct> constructs) {
        Constructor constructor = new Constructor(){
            {
                for (ConfigurationConstruct construct : constructs) {
                    this.yamlConstructors.put(new Tag(construct.getName()), construct);
                }
            }
        };
        final Yaml yaml = new Yaml(constructor);
        this.yamlParser = new ExtensionParser(){

            @Override
            public Extension parse(ClassLoader classloader, InputStream inputStream, boolean custom) throws Exception {
                Object config = yaml.load(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
                if (config instanceof Map) {
                    return new YamlExtension(classloader, (Map)config, custom);
                }
                throw new Exception("Invalid yaml extension");
            }
        };
        this.xmlParser = new ExtensionParser(){

            @Override
            public Extension parse(ClassLoader classloader, InputStream inputStream, boolean custom) throws Exception {
                com.newrelic.agent.extension.beans.Extension ext = ExtensionDomParser.readFile(inputStream);
                return new XmlExtension(this.getClass().getClassLoader(), ext.getName(), ext, custom);
            }
        };
    }

    public ExtensionParser getParser(String fileName) {
        if (fileName.endsWith(".yml")) {
            return this.yamlParser;
        }
        return this.xmlParser;
    }

    public ExtensionParser getXmlParser() {
        return this.xmlParser;
    }

    public ExtensionParser getYamlParser() {
        return this.yamlParser;
    }

    public static interface ExtensionParser {
        public Extension parse(ClassLoader var1, InputStream var2, boolean var3) throws Exception;
    }
}

