/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.datastore.DatabaseVendor;
import com.newrelic.agent.database.DDLStatementFactory;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.DefaultStatementFactory;
import com.newrelic.agent.database.InnerSelectStatementFactory;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.database.SelectVariableStatementFactory;
import com.newrelic.agent.database.StatementFactory;
import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDatabaseStatementParser
implements DatabaseStatementParser {
    static final int PATTERN_SWITCHES = 34;
    static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*select.*?\\sfrom[\\s\\[]+([^\\]\\s,)(;]*).*", 34);
    private static final Pattern COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern NR_HINT_PATTERN = Pattern.compile("\\s*/\\*\\s*nrhint\\s*:\\s*([^\\*]*)\\s*\\*/\\s*([^\\s]*).*", 32);
    private static final Pattern VALID_METRIC_NAME_MATCHER = Pattern.compile("[a-zA-Z0-9.$_@]+");
    private static final Pattern EXEC_VAR_PATTERN = Pattern.compile(".*(?:exec|execute)\\s+[^\\s(,]*.*?=(?:\\s|)([^\\s]*)", 34);
    private final Set<String> knownOperations;
    private final List<StatementFactory> statementFactories = Arrays.asList(new InnerSelectStatementFactory(), new DefaultStatementFactory("show", Pattern.compile("^\\s*show\\s+(.*)$", 34), false){

        @Override
        protected boolean isValidModelName(String name) {
            return true;
        }
    }, new DefaultStatementFactory("insert", Pattern.compile("^\\s*insert(?:\\s+ignore)?(?:\\s+into)?\\s+([^\\s(,;]*).*", 34), true), new DefaultStatementFactory("update", Pattern.compile("^\\s*update\\s+([^\\s,;]*).*", 34), true), new DefaultStatementFactory("delete", Pattern.compile("^\\s*delete\\s*?.*?\\s+from\\s+([^\\s,(;]*).*", 34), true), new DefaultStatementFactory("with", Pattern.compile("^\\s*with\\s+(?:recursive\\s+)?([^\\s,(;]*)", 34), true), new DDLStatementFactory("create", Pattern.compile("^\\s*create\\s+procedure.*", 34), "Procedure"), new SelectVariableStatementFactory(), new DDLStatementFactory("drop", Pattern.compile("^\\s*drop\\s+procedure.*", 34), "Procedure"), new DDLStatementFactory("create", Pattern.compile("^\\s*create\\s+table.*", 34), "Table"), new DDLStatementFactory("drop", Pattern.compile("^\\s*drop\\s+table.*", 34), "Table"), new DefaultStatementFactory("alter", Pattern.compile("^\\s*alter\\s+([^\\s]*).*", 34), false), new DefaultStatementFactory("call", Pattern.compile(".*call\\s+([^\\s(,]*).*", 34), true), new DefaultStatementFactory("exec", Pattern.compile(".*(?:exec|execute)\\s+(?!as\\s+)([^\\s(,=;]*+);?\\s*+(?:[^=]|$).*", 34), true, EXEC_VAR_PATTERN), new DefaultStatementFactory("set", Pattern.compile("^\\s*set\\s+(.*)\\s*(as|=).*", 34), false));

    public DefaultDatabaseStatementParser() {
        this.knownOperations = new HashSet<String>();
        for (StatementFactory factory : this.statementFactories) {
            this.knownOperations.add(factory.getOperation());
        }
    }

    @Override
    public ParsedDatabaseStatement getParsedDatabaseStatement(DatabaseVendor databaseVendor, String statement, ResultSetMetaData metaData) {
        Matcher hintMatcher = NR_HINT_PATTERN.matcher(statement);
        if (hintMatcher.matches()) {
            String model = hintMatcher.group(1).trim().toLowerCase();
            String operation = hintMatcher.group(2).toLowerCase();
            if (!this.knownOperations.contains(operation)) {
                operation = "unknown";
            }
            return new ParsedDatabaseStatement(model, operation, true);
        }
        if (metaData != null) {
            try {
                String tableName;
                int columnCount = metaData.getColumnCount();
                if (columnCount > 0 && !StringUtils.isEmpty(tableName = metaData.getTableName(1))) {
                    return new ParsedDatabaseStatement(tableName.toLowerCase(), "select", true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.parseStatement(statement);
    }

    ParsedDatabaseStatement parseStatement(String statement) {
        try {
            statement = COMMENT_PATTERN.matcher(statement).replaceAll("");
            for (StatementFactory factory : this.statementFactories) {
                ParsedDatabaseStatement parsedStatement = factory.parseStatement(statement);
                if (parsedStatement == null) continue;
                return parsedStatement;
            }
            Agent.LOG.log(Level.FINE, "Returning UNPARSEABLE_STATEMENT for statement: {0}", statement);
            return UNPARSEABLE_STATEMENT;
        }
        catch (Throwable t) {
            Agent.LOG.fine(MessageFormat.format("Unable to parse sql \"{0}\" - {1}", statement, t.toString()));
            Agent.LOG.log(Level.FINER, "SQL parsing error", t);
            Agent.LOG.log(Level.FINE, t, "Returning UNPARSEABLE_STATEMENT for statement: {0}", statement);
            return UNPARSEABLE_STATEMENT;
        }
    }

    static boolean isValidName(String string) {
        return VALID_METRIC_NAME_MATCHER.matcher(string).matches();
    }
}

