/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.InfiniteTracingConfig;
import com.newrelic.agent.config.InfiniteTracingSpanEventsConfig;
import com.newrelic.agent.config.InfiniteTracingTraceObserverConfig;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class InfiniteTracingConfigImpl
extends BaseConfig
implements InfiniteTracingConfig {
    public static final String ROOT = "infinite_tracing";
    public static final String TRACE_OBSERVER = "trace_observer";
    public static final String SPAN_EVENTS = "span_events";
    public static final String FLAKY_PERCENTAGE = "_flakyPercentage";
    public static final String USE_PLAINTEXT = "plaintext";
    public static final boolean DEFAULT_USE_PLAINTEXT = false;
    static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.infinite_tracing.";
    private final InfiniteTracingTraceObserverConfig traceObserverConfig;
    private final InfiniteTracingSpanEventsConfig spanEventsConfig;
    private final boolean autoAppNamingEnabled;

    public InfiniteTracingConfigImpl(Map<String, Object> props) {
        this(props, false);
    }

    public InfiniteTracingConfigImpl(Map<String, Object> props, boolean autoAppNamingEnabled) {
        super(props, SYSTEM_PROPERTY_ROOT);
        if (props != null && props.containsKey(FLAKY_PERCENTAGE)) {
            Agent.LOG.log(Level.WARNING, "Infinite Tracing config contains a flaky percentage value");
        }
        this.autoAppNamingEnabled = autoAppNamingEnabled;
        this.traceObserverConfig = this.createTracerObserverConfig();
        this.spanEventsConfig = this.createSpanEventsConfig();
    }

    private InfiniteTracingSpanEventsConfig createSpanEventsConfig() {
        Map<String, Object> spanEventProps = this.getProperty(SPAN_EVENTS, Collections.emptyMap());
        return new InfiniteTracingSpanEventsConfig(spanEventProps, SYSTEM_PROPERTY_ROOT);
    }

    private InfiniteTracingTraceObserverConfig createTracerObserverConfig() {
        Map<String, Object> traceObserverProps = this.getProperty(TRACE_OBSERVER, Collections.emptyMap());
        return new InfiniteTracingTraceObserverConfig(traceObserverProps, SYSTEM_PROPERTY_ROOT);
    }

    @Override
    public String getTraceObserverHost() {
        return this.traceObserverConfig.getHost();
    }

    @Override
    public int getTraceObserverPort() {
        return this.traceObserverConfig.getPort();
    }

    @Override
    public int getSpanEventsQueueSize() {
        return this.spanEventsConfig.getQueueSize();
    }

    @Override
    public Double getFlakyPercentage() {
        return (Double)this.getProperty(FLAKY_PERCENTAGE);
    }

    @Override
    public boolean getUsePlaintext() {
        return this.getProperty(USE_PLAINTEXT, false);
    }

    @Override
    public boolean isEnabled() {
        if (!this.getTraceObserverHost().isEmpty() && this.autoAppNamingEnabled) {
            Agent.LOG.log(Level.WARNING, "Infinite Tracing is disabled because enable_auto_app_naming is set to true.");
            return false;
        }
        return !this.getTraceObserverHost().isEmpty();
    }
}

