/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.ChannelFactory;
import com.newrelic.ChannelSupplier;
import com.newrelic.ChannelToStreamObserver;
import com.newrelic.ConnectionHeaders;
import com.newrelic.ConnectionStatus;
import com.newrelic.DaemonThreadFactory;
import com.newrelic.DefaultBackoffPolicy;
import com.newrelic.DisconnectionHandler;
import com.newrelic.FlakyHeaderInterceptor;
import com.newrelic.GrpcSpanConverter;
import com.newrelic.HeadersInterceptor;
import com.newrelic.InfiniteTracingConfig;
import com.newrelic.LoopForever;
import com.newrelic.ResponseObserver;
import com.newrelic.SpanConverter;
import com.newrelic.SpanDelivery;
import com.newrelic.StreamObserverFactory;
import com.newrelic.StreamObserverSupplier;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.interfaces.backport.Consumer;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.trace.v1.V1;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class SpanEventConsumer
implements Consumer<SpanEvent> {
    private final BlockingQueue<SpanEvent> queue;
    private final MetricAggregator aggregator;
    private final ConnectionHeaders connectionHeaders;
    private final Runnable spanSender;
    private final ExecutorService executorService;
    private final AtomicBoolean wasStarted = new AtomicBoolean(false);
    private volatile Future<?> senderFuture;

    private SpanEventConsumer(BlockingQueue<SpanEvent> queue, MetricAggregator aggregator, ConnectionHeaders connectionHeaders, Runnable spanSender, ExecutorService executorService) {
        this.queue = queue;
        this.aggregator = aggregator;
        this.connectionHeaders = connectionHeaders;
        this.spanSender = spanSender;
        this.executorService = executorService;
    }

    @Override
    public void accept(SpanEvent spanEvent) {
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Span/Seen");
        this.queue.offer(spanEvent);
    }

    public static Builder builder(InfiniteTracingConfig config, MetricAggregator metricAggregator) {
        return new Builder(config, metricAggregator);
    }

    public void start() {
        if (this.wasStarted.compareAndSet(false, true)) {
            this.senderFuture = this.executorService.submit(this.spanSender);
        }
    }

    public void stop() {
        if (this.wasStarted.compareAndSet(true, false)) {
            this.senderFuture.cancel(true);
            this.senderFuture = null;
        }
    }

    public void setConnectionMetadata(String newRunToken, Map<String, String> headers) {
        this.connectionHeaders.set(newRunToken, headers);
    }

    public static class Builder {
        private final InfiniteTracingConfig config;
        private final SpanConverter<V1.Span> spanConverter = new GrpcSpanConverter();
        private final MetricAggregator metricAggregator;
        private final Logger logger;
        private final BlockingQueue<SpanEvent> queue;
        private ChannelFactory channelFactory;
        private StreamObserverFactory streamObserverFactory;

        public Builder(InfiniteTracingConfig config, MetricAggregator metricAggregator) {
            this.logger = config.getLogger();
            this.queue = new LinkedBlockingQueue<SpanEvent>(config.getMaxQueueSize());
            this.metricAggregator = metricAggregator;
            this.config = config;
        }

        @VisibleForTesting
        public Builder setChannelFactory(ChannelFactory channelFactory) {
            this.channelFactory = channelFactory;
            return this;
        }

        @VisibleForTesting
        public Builder setStreamObserverFactory(StreamObserverFactory streamObserverFactory) {
            this.streamObserverFactory = streamObserverFactory;
            return this;
        }

        public SpanEventConsumer build() {
            DefaultBackoffPolicy backoffPolicy = new DefaultBackoffPolicy();
            ConnectionStatus connectionStatus = new ConnectionStatus(this.logger);
            ConnectionHeaders connectionHeaders = new ConnectionHeaders(connectionStatus, this.logger, this.config.getLicenseKey());
            HeadersInterceptor clientInterceptor = new HeadersInterceptor(connectionHeaders);
            FlakyHeaderInterceptor maybeInjectFlakyHeader = new FlakyHeaderInterceptor(this.config);
            DisconnectionHandler disconnectionHandler = new DisconnectionHandler(connectionStatus, backoffPolicy, this.logger);
            AtomicBoolean shouldRecreateCall = new AtomicBoolean(false);
            ResponseObserver responseObserver = new ResponseObserver(this.metricAggregator, this.logger, disconnectionHandler, shouldRecreateCall);
            ChannelFactory channelFactory = this.channelFactory != null ? this.channelFactory : new ChannelFactory(this.config, clientInterceptor, maybeInjectFlakyHeader);
            StreamObserverFactory streamObserverFactory = this.streamObserverFactory != null ? this.streamObserverFactory : new StreamObserverFactory(this.metricAggregator, responseObserver);
            ChannelToStreamObserver channelToStreamObserverConverter = new ChannelToStreamObserver(streamObserverFactory, shouldRecreateCall);
            ChannelSupplier channelSupplier = new ChannelSupplier(channelFactory, connectionStatus, this.logger);
            StreamObserverSupplier streamObserverSupplier = new StreamObserverSupplier(channelSupplier, channelToStreamObserverConverter);
            SpanDelivery spanDeliveryConsumer = new SpanDelivery(this.spanConverter, this.metricAggregator, this.logger, this.queue, streamObserverSupplier);
            LoopForever loopForever = new LoopForever(this.logger, spanDeliveryConsumer);
            ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("Span Event Consumer"));
            return new SpanEventConsumer(this.queue, this.metricAggregator, connectionHeaders, loopForever, executorService);
        }
    }
}

